<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\AboutUs;

class AboutUsController extends Controller
{
    // List all AboutUs records
    public function index() {
        $abouts = AboutUs::all();
         return view('admin.aboutus.list', compact('abouts'));
    }

    // Show create form
    public function create() {
        return view('admin.aboutus.create');
    }

    // Store new AboutUs record
    public function store(Request $request) {
        $request->validate([
            'title' => 'required|min:3',
            'description' => 'required|min:5',
        ]);

        $about = new AboutUs();

        if ($request->hasFile('image')) {
            $image = $request->file('image');
            $imageName = time() . '_' . $image->getClientOriginalName();
            $image->move(public_path('uploads/aboutus'), $imageName);
            $about->image = 'uploads/aboutus/' . $imageName;
        }

        if ($request->hasFile('image1')) {
    $image1 = $request->file('image1');
    $image1Name = time().'_1.'.$image1->getClientOriginalExtension();
    $image1->move(public_path('uploads/aboutus'), $image1Name);
    $about->image1 = 'uploads/aboutus/' . $image1Name;
}

        $about->title = $request->title;
        $about->description = $request->description;
        $about->url = $request->url;

        $about->save();  

        return redirect()->route('aboutus.edit', $about->id)->with('success', 'About Us added successfully.');
    }

    // Show edit form
    public function edit($id) {
    $about = AboutUs::findOrFail($id); // fetch the record
    return view('admin.aboutus.edit', compact('about')); // pass the full object
}
 
    // Update AboutUs record
    public function update(Request $request, $id) {
        $request->validate([
            'title' => 'required|min:3',
            'description' => 'required|min:5',
        ]);

        $about = AboutUs::findOrFail($id);

        if ($request->hasFile('image')) {
            if ($about->image && file_exists(public_path($about->image))) {
                unlink(public_path($about->image));
            }
            $image = $request->file('image');
            $imageName = time() . '_' . $image->getClientOriginalName();
            $image->move(public_path('uploads/aboutus'), $imageName);
            $about->image = 'uploads/aboutus/' . $imageName;
        }

        $about->title = $request->title;
        $about->description = $request->description;
        $about->url = $request->url;

        $about->save();

return redirect()->route('aboutus.edit', $about->id)->with('success', 'About Us added successfully.');
    }

    // Delete AboutUs record
    public function destroy($id) {
        $about = AboutUs::findOrFail($id);
        if ($about->image && file_exists(public_path($about->image))) {
            unlink(public_path($about->image));
        }
        $about->delete();

        return redirect()->route('aboutus.index')->with('success', 'About Us deleted successfully.');
    }
}