<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\ContactUs;

class ContactUsController extends Controller
{
    // Show all contacts
    public function index() {
        $contacts = ContactUs::all();
        return view('admin.contactus.list', compact('contacts'));
    }

    // Show create form
    public function create() {
        return view('admin.contactus.create');
    }

    // Store new contact
    public function store(Request $request) {
        $request->validate([
            'logo' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
            'name' => 'required|string|max:255',
            'address' => 'required|string|max:255',
            'email' => 'required|email',
            'phone' => 'required|string|max:20',
        ]);

        $contact = new ContactUs();

        // Handle logo upload
        if ($request->hasFile('logo')) {
            $logo = $request->file('logo');
            $logoName = time() . '_' . $logo->getClientOriginalName();
            $logo->move(public_path('uploads/contactus'), $logoName);
            $contact->logo = 'uploads/contactus/' . $logoName;
        }

        $contact->name = $request->name;
        $contact->address = $request->address;
        $contact->email = $request->email;
        $contact->phone = $request->phone;

        $contact->save();

        return redirect()->route('contactus.edit', $contact->id)
                         ->with('success', 'Contact added successfully.');
    }

    // Show edit form
    public function edit($id) {
        $contact = ContactUs::findOrFail($id);
        return view('admin.contactus.edit', compact('contact'));
    }

    // Update contact
    public function update(Request $request, $id) {
        $request->validate([
            'logo' => 'nullable|image|mimes:jpeg,png,jpg,gif|max:2048',
            'name' => 'required|string|max:255',
            'address' => 'required|string|max:255',
            'email' => 'required|email',
            'phone' => 'required|string|max:20',
        ]);

        $contact = ContactUs::findOrFail($id);

        // Update logo if uploaded
        if ($request->hasFile('logo')) {
            if ($contact->logo && file_exists(public_path($contact->logo))) {
                unlink(public_path($contact->logo));
            }

            $logo = $request->file('logo');
            $logoName = time() . '_' . $logo->getClientOriginalName();
            $logo->move(public_path('uploads/contactus'), $logoName);
            $contact->logo = 'uploads/contactus/' . $logoName;
        }

        $contact->name = $request->name;
        $contact->address = $request->address;
        $contact->email = $request->email;
        $contact->phone = $request->phone;

        $contact->save();

        return redirect()->route('contactus.edit', $contact->id)
                         ->with('success', 'Contact updated successfully.');
    }

    // Delete contact
    public function destroy($id) {
        $contact = ContactUs::findOrFail($id);

        if ($contact->logo && file_exists(public_path($contact->logo))) {
            unlink(public_path($contact->logo));
        }

        $contact->delete();

        return redirect()->route('contactus.index')
                         ->with('success', 'Contact deleted successfully.');
    }
}
