<?php

namespace App\Http\Controllers;

use App\Models\FeatureWork;
use Illuminate\Http\Request;

class FeatureWorkController extends Controller
{
    // Display list of feature works
    public function index()
    {
        $features = FeatureWork::all();
        return view('admin.featurework.list', compact('features')); // matches your list.blade.php
    }

    // Show create form
    public function create()
    {
        return view(' admin.featurework.create'); // matches create.blade.php
    }

    // Store new feature work
    public function store(Request $request)
{
    $request->validate([

    ]);

    $feature = new FeatureWork();

    if ($request->hasFile('image1')) {
        $image1 = $request->file('image1');
        $imageName = time().'_'.$image1->getClientOriginalName();
        $image1->move(public_path('uploads/featurework'), $imageName);
        $feature->image1 = 'uploads/featurework/' . $imageName;
    }

     if ($request->hasFile('image2')) {
        $image2 = $request->file('image2');
        $imageName = time().'_'.$image2->getClientOriginalName();
        $image2->move(public_path('uploads/featurework'), $imageName);
        $feature->image2 = 'uploads/featurework/' . $imageName;
    }
     if ($request->hasFile('image3')) {
        $image3 = $request->file('image3');
        $imageName = time().'_'.$image3->getClientOriginalName();
        $image3->move(public_path('uploads/featurework'), $imageName);
        $feature->image3 = 'uploads/featurework/' . $imageName;
    }
     if ($request->hasFile('image4')) {
        $image4 = $request->file('image4');
        $imageName = time().'_'.$image4->getClientOriginalName();
        $image4->move(public_path('uploads/featurework'), $imageName);
        $feature->image4 = 'uploads/featurework/' . $imageName;
    }


    $feature->heading = $request->heading;
    $feature->save();

    return redirect()->route('featureworks.index')->with('success', 'Feature created successfully.');
}


    // Show edit form
    public function edit($id)
    {
        $feature = FeatureWork::findOrFail($id);
        return view('admin.featurework.edit', compact('feature')); // matches edit.blade.php
    }

    // Update feature work
    public function update(Request $request, $id)
    {
                           
        $request->validate([

        ]);
        
        $feature = FeatureWork::findOrFail($id); 
        if ($request->hasFile('image')) {
            // Delete old image
            if ($feature->image && file_exists(public_path($feature->image))) {
                unlink(public_path($feature->image));
            }
            
            $image = $request->file('image');
            $imageName = time().'_'.$image->getClientOriginalName();
            $image->move(public_path('uploads/featurework'), $imageName);
            $feature->image = 'uploads/featurework/' . $imageName;
        }

        $feature->heading = $request->heading;
        $feature->save();

        return redirect()->route('featureworks.index')->with('success', 'Feature updated successfully.');
    }

    // Delete feature work
    public function destroy($id) {
        $feature = FeatureWork::findOrFail($id);
        $feature->delete();

        return redirect()->route('featureworks.index')->with('success', 'Feature deleted successfully.');
    }
}
