<?php
namespace App\Http\Controllers;

use App\Models\LetsTalk;
use Illuminate\Http\Request;

class LetsTalkController extends Controller
{
    // Display all records
    public function index()
    {
        $letstalks = LetsTalk::all();
        return view('admin.letstalk.list', compact('letstalks'));
    }

    // Show create form
    public function create()
    {
        return view('admin.letstalk.create');
    }

    // Store record
    public function store(Request $request)
    {
        $request->validate([
            'title' => 'required|min:3',
            'number' => 'required|min:3',
            'num1' => 'required|', // use your actual DB column name
        ]);

        LetsTalk::create([
            'title' => $request->title,
            'number' => $request->number,
            'num1' => $request->num1,
        ]);

        return redirect()->route('letstalk.index')->with('success', "Let's Talk content added successfully!");
    }

    // Edit page
    public function edit($id)
    {
        $letstalk = LetsTalk::findOrFail($id);
        return view('admin.letstalk.edit', compact('letstalk'));
    }

    // Update record
    public function update(Request $request, $id)
    {
        $request->validate([
            'title' => 'required|min:3',
            'number' => 'required|min:3',
            'num1' => 'required|', // must match DB column
        ]);

        $letstalk = LetsTalk::findOrFail($id);
        $letstalk->update([
            'title' => $request->title,
            'number' => $request->number,
            'num1' => $request->num1,
        ]);

        return redirect()->route('letstalk.index')->with('success', "Let's Talk content updated successfully!");
    }

    // Delete record
    public function destroy($id)
    {
        $letstalk = LetsTalk::findOrFail($id);
        $letstalk->delete();

        return redirect()->route('letstalk.index')->with('success', "Let's Talk content deleted successfully!");
    }
}
