<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Slider;

class SliderController extends Controller
{
    public function index() {
        $sliders = Slider::all();
        return view('admin.slider.list', compact('sliders'));
    }

    public function create() {
        return view('admin.slider.create');
    }

    
    public function store(Request $request) {
        $request->validate([

        ]);

        $slider = new Slider();

        if ($request->hasFile('image')) {
            $image = $request->file('image');
            $imageName = time() . '_' . $image->getClientOriginalName();
            $image->move(public_path('uploads/slider'), $imageName);
            $slider->image = 'uploads/slider/' . $imageName;
        }

        $slider->url = $request->url;
        $slider->heading = $request->heading;
        $slider->para = $request->para;

        $slider->save();

        return redirect()->route('sliders.index')->with('success', 'Slider added successfully.');
    }

public function update(Request $request, $id)
{
    $request->validate([

    ]);

    $slider = Slider::findOrFail($id);

    // Update image if a new one is uploaded
    if ($request->hasFile('image')) {
        // Delete old image if it exists
        if ($slider->image && file_exists(public_path($slider->image))) {
            unlink(public_path($slider->image));
        }

        $image = $request->file('image');
        $imageName = time() . '_' . $image->getClientOriginalName();
        $image->move(public_path('uploads/slider'), $imageName);
        $slider->image = 'uploads/slider/' . $imageName;
    }

    // Update other fields
    $slider->url = $request->url;
    $slider->heading = $request->heading;
    $slider->para = $request->para;

    $slider->save();

    return redirect()->route('sliders.index')->with('success', 'Slider updated successfully.');
}

    public function edit($id) {
        $slider = Slider::findOrFail($id);
        return view('admin.slider.edit', compact('slider'));
    }


    public function destroy($id) {
        $slider = Slider::findOrFail($id);
        $slider->delete();

        return redirect()->route('sliders.index')->with('success', 'Slider deleted successfully.');
    }
}