<?php

namespace App\Http\Controllers;

use App\Models\Team;
use Illuminate\Http\Request;

class TeamController extends Controller
{
    // List all members
    public function index()
    {
        $teams = Team::all();
        return view('admin.team.list', compact('teams'));
    }

    // Show create form
    public function create()
    {
        return view('admin.team.create');
    }

    // Store new team member
    public function store(Request $request)
    {
        $request->validate([
            'heading' => 'nullable|string|max:255',
            'name' => 'required|string|max:255',
            'designation' => 'required|string|max:255',
            'image' => 'nullable|image',
        ]);

        $data = $request->all();

        // Upload image to public/uploads/team
        if ($request->hasFile('image')) {
            $image = $request->file('image');
            $imageName = time() . '_' . $image->getClientOriginalName();
            $image->move(public_path('uploads/team'), $imageName);
            $data['image'] = 'uploads/team/' . $imageName;
        }

        Team::create($data);

        return redirect()->route('team.index')->with('success', 'Team member added successfully!');
    }

    // Show edit form
    public function edit($id)
    {
        $team = Team::findOrFail($id);
        return view('admin.team.edit', compact('team'));
    }

    // Update team member
    public function update(Request $request, $id)
    {
        $team = Team::findOrFail($id);

        $request->validate([
            'heading' => 'nullable|string|max:255',
            'name' => 'required|string|max:255',
            'designation' => 'required|string|max:255',
            'image' => 'nullable|image',
        ]);

        $data = $request->all();

        // Handle image upload
        if ($request->hasFile('image')) {
            // Delete old image if exists
            if ($team->image && file_exists(public_path($team->image))) {
                unlink(public_path($team->image));
            }

            // Store new image
            $image = $request->file('image');
            $imageName = time() . '_' . $image->getClientOriginalName();
            $image->move(public_path('uploads/team'), $imageName);
            $data['image'] = 'uploads/team/' . $imageName;
        }

        $team->update($data);

        return redirect()->route('team.index')->with('success', 'Team member updated successfully!');
    }

    // Delete team member
    public function destroy($id)
    {
        $team = Team::findOrFail($id);

        // Delete image if exists
        if ($team->image && file_exists(public_path($team->image))) {
            unlink(public_path($team->image));
        }

        $team->delete();

        return redirect()->route('team.index')->with('success', 'Team member deleted successfully!');
    }
}
