<?php

namespace App\Http\Controllers;

use App\Models\Testimonial;
use Illuminate\Http\Request;

class TestimonialController extends Controller
{
    // Display list
    public function index()
    {
        $testimonials = Testimonial::all();
        return view('admin.testimonial.list', compact('testimonials'));
    }

    // Show create form
    public function create()
    {
        return view('admin.testimonial.create');
    }

    // Store data
    public function store(Request $request)
    {
        $request->validate([
            
            'name' => 'required',
            'paragraph' => 'required',
            'image' => 'nullable|image',
            'image1' => 'nullable|image',
            'star' => 'required|integer|min:1|max:5',
            'description' => 'required',

        ]);

        $testimonial = new Testimonial();

        // Upload first image
        if ($request->hasFile('image')) {
            $image = $request->file('image');
            $imageName = time().'_'.$image->getClientOriginalName();
            $image->move(public_path('uploads/testimonial'), $imageName);
            $testimonial->image = 'uploads/testimonial/'.$imageName;
        }

        // Upload second image
        if ($request->hasFile('image1')) {
            $image1 = $request->file('image1');
            $imageName1 = time().'_'.$image1->getClientOriginalName();
            $image1->move(public_path('uploads/testimonial'), $imageName1);
            $testimonial->image1 = 'uploads/testimonial/'.$imageName1;
        }

        $testimonial->heading = $request->heading;
        $testimonial->name = $request->name;
        $testimonial->paragraph = $request->paragraph;
        $testimonial->star = $request->star;
        $testimonial->description = $request->description;

        $testimonial->save();

        return redirect()->route('testimonials.index')->with('success', 'Testimonial added successfully!');
    }

    // Show edit form
    public function edit($id)
    {
        $testimonial = Testimonial::findOrFail($id);
        return view('admin.testimonial.edit', compact('testimonial'));
    }

    // Update data
    public function update(Request $request, $id)
    {
        $testimonial = Testimonial::findOrFail($id);

        $request->validate([
            'description' => 'required',
            'name' => 'required',
            'paragraph' => 'required',
            'image' => 'nullable|image',
            'image1' => 'nullable|image',
            'star' => 'required|integer|min:1|max:5',

        ]);

        // Upload new image if exists
        if ($request->hasFile('image')) {
            if ($testimonial->image && file_exists(public_path($testimonial->image))) {
                unlink(public_path($testimonial->image));
            }
            $image = $request->file('image');
            $imageName = time().'_'.$image->getClientOriginalName();
            $image->move(public_path('uploads/testimonial'), $imageName);
            $testimonial->image = 'uploads/testimonial/'.$imageName;
        }

        if ($request->hasFile('image1')) {
            if ($testimonial->image1 && file_exists(public_path($testimonial->image1))) {
                unlink(public_path($testimonial->image1));
            }
            $image1 = $request->file('image1');
            $imageName1 = time().'_'.$image1->getClientOriginalName();
            $image1->move(public_path('uploads/testimonial'), $imageName1);
            $testimonial->image1 = 'uploads/testimonial/'.$imageName1;
        }

        // Update other fields
        $testimonial->heading = $request->heading;
        $testimonial->name = $request->name;
        $testimonial->paragraph = $request->paragraph;
        $testimonial->star = $request->star;
        $testimonial->description = $request->description;

        $testimonial->save();

        return redirect()->route('testimonials.index')->with('success', 'Testimonial updated successfully!');
    }

    // Delete record
    public function destroy($id)
    {
        $testimonial = Testimonial::findOrFail($id);

        // Delete images if exist
        if ($testimonial->image && file_exists(public_path($testimonial->image))) {
            unlink(public_path($testimonial->image));
        }
        if ($testimonial->image1 && file_exists(public_path($testimonial->image1))) {
            unlink(public_path($testimonial->image1));
        }

        $testimonial->delete();

        return redirect()->route('testimonials.index')->with('success', 'Testimonial deleted successfully!');
    }
}
