@extends('layouts.admin.app')

@section('content')
<div>
    <h1>Edit About Us Content</h1>
    <div class="d-block justify-content-center bg-white p-3">

        <form class="container w-50 mx-auto d-flex flex-column" 
              action="{{ route('aboutus.update', $about->id) }}" 
              method="POST" 
              enctype="multipart/form-data">
              
            @csrf
            @method('PUT')

            <label>Title</label>
            <input type="text" name="title" value="{{ old('title', $about->title) }}" class="mb-3 form-control" placeholder="Title">

            <label>Description</label>
            <textarea name="description" class="mb-3 form-control" placeholder="Description">{{ old('description', $about->description) }}</textarea>

            <label>Current Image 1</label><br>
            @if($about->image)
                <img src="{{ asset('storage/'.$about->image) }}" alt="Image 1" width="150" class="mb-3">
            @else
                <p class="text-muted">No image uploaded</p>
            @endif
            <input type="file" name="image" class="mb-3 form-control">

            <label>Current Image 2</label><br>
            @if($about->image1)
                <img src="{{ asset('storage/'.$about->image1) }}" alt="Image 2" width="150" class="mb-3">
            @else
                <p class="text-muted">No image uploaded</p>
            @endif
            <input type="file" name="image1" class="mb-3 form-control">

            <label>URL</label>
            <input type="text" name="url" value="{{ old('url', $about->url) }}" class="mb-3 form-control" placeholder="URL">

            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-success text-white">Update</button>
                <a href="{{ route('aboutus.create') }}" class="btn btn-secondary">Back</a>
            </div>
        </form>

    </div>
</div>
@endsection
