@extends('layouts.admin.app')

@section('content')
<h1>About Us List</h1>

<a href="{{ route('aboutus.create') }}" class="btn btn-primary mb-3">Add New</a>

<table class="table table-bordered">
  <thead>
    <tr>
      <th>ID</th>
      <th>Image</th>
      <th>Image1</th>
      <th>URL</th>
      <th>Title</th>
      <th>Paragraph</th>
      <th>Actions</th>
    </tr>
  </thead>
  <tbody>
    @forelse($abouts as $about)
      <tr>
        <td>{{ $about->id }}</td>
        <td>
          @if($about->image)
            <img src="{{ asset($about->image) }}" alt="Image" width="80">
          @else
            No Image
          @endif
        </td>
        <td>{{ $about->url }}</td>
        <td>{{ $about->title }}</td>
        <td>{{ $about->description }}</td>
        <td>
          <a href="{{ route('aboutus.edit', $about->id) }}" class="btn btn-warning btn-sm">Edit</a>

          <form action="{{ route('aboutus.destroy', $about->id) }}" method="POST" style="display:inline-block;">
            @csrf
            @method('DELETE')
            <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure?')">Delete</button>
          </form>
        </td>
      </tr>
    @empty
      <tr>
        <td colspan="6" class="text-center">No records found.</td>
      </tr>
    @endforelse
  </tbody>
</table>
@endsection
