@extends('layouts.admin.app')

@section('content')
<div>
    <h1>Edit Contact Us Content</h1>
    <div class="d-block justify-content-center bg-white p-3">

        <form class="container w-50 justify-content-start align-items-start d-flex flex-column " 
              action="{{ route('contactus.update', $contact->id) }}" 
              method="POST" 
              enctype="multipart/form-data">
              
            @csrf
            @method('PUT')

              <label>Logo</label><br>
            @if($contact->image)
                <img src="{{ asset('storage/'.$contact->image) }}" alt="logo" width="150" class="mb-3">
            @else
                <p class="text-muted">No image uploaded</p>
            @endif
            <input type="file" name="image" class="mb-3 form-control">

            <label>Name</label>
            <textarea name="name" class="mb-3 form-control" placeholder="Name">{{ old('name', $contact->name) }}</textarea>

            <label>Email</label>
            <input type="text" name="email" value="{{ old('email', $contact->email) }}" class="mb-3 form-control" placeholder="Email">

            <label>Address</label>
            <input type="text" name="address" value="{{ old('address', $contact->address) }}" class="mb-3 form-control" placeholder="Address">

            <label>Phone</label>
            <input type="text" name="phone" value="{{ old('phone', $contact->phone) }}" class="mb-3 form-control" placeholder="Phone">
            <div class="d-flex gap-2">
                <button type="submit" class="btn btn-success text-white">Update</button>
                <a href="{{ route('contactus.create') }}" class="btn btn-secondary">Back</a>
            </div>
        </form>

    </div>
</div>
@endsection
