@extends('layouts.admin.app')

@section('content')
<h1>Contact Us List</h1>

<a href="{{ route('contactus.create') }}" class="btn btn-primary mb-3">Add New</a>

<table class="table table-bordered">
  <thead>
    <tr>
      <th>SR</th>
      <th>Logo</th>
      <th>Name</th>
      <th>Email</th>
      <th>Address</th>
      <th>Phone</th>
      <th>Actions</th>
    </tr>
  </thead>
  <tbody>
    @forelse($contacts as $contact)
      <tr>
        <td>{{ $contact->id }}</td>
        <td>
          @if($contact->image)
            <img src="{{ asset($contact->image) }}" alt="Image" width="80">
          @else
            No Image
          @endif
        </td>
        <td>{{ $contact->name }}</td>
        <td>{{ $contact->email }}</td>
        <td>{{ $contact->address }}</td>
        <td>{{ $contact->phone }}</td>
        <td>
          <a href="{{ route('contactus.edit', $contact->id) }}" class="btn btn-warning btn-sm">Edit</a>

          <form action="{{ route('contactus.destroy', $contact->id) }}" method="POST" style="display:inline-block;">
            @csrf
            @method('DELETE')
            <button type="submit" class="btn btn-danger btn-sm" onclick="return confirm('Are you sure?')">Delete</button>
          </form>
        </td>
      </tr>
    @empty
      <tr>
        <td colspan="6" class="text-center">No records found.</td>
      </tr>
    @endforelse
  </tbody>
</table>
@endsection
