@extends('layouts.admin.app')

@section('content')
<div class="container mt-5">
    <h2>Add New Feature</h2>

    @if($errors->any())
        <div class="alert alert-danger">
            <ul>@foreach($errors->all() as $error)<li>{{ $error }}</li>@endforeach</ul>
        </div>
    @endif

    <form action="{{ route('featureworks.store') }}" method="POST" enctype="multipart/form-data">
        @csrf
        <div class="mb-3">
            <label for="heading" class="form-label">Heading</label>
            <input type="text" name="heading" class="form-control" id="heading" value="{{ old('heading') }}" required>
        </div>

        <div class="mb-3">
            <label for="image1" class="form-label">Image 1</label>
            <input type="file" name="image1" class="form-control" id="image1" required>
        </div>
        <div class="mb-3">
            <label for="image2" class="form-label">Image 2</label>
            <input type="file" name="image2" class="form-control" id="image2" required>
        </div>
        <div class="mb-3">
            <label for="image3" class="form-label">Image 3</label>
            <input type="file" name="image3" class="form-control" id="image3" required>
        </div>
        <div class="mb-3">
            <label for="image4" class="form-label">Image 4</label>
            <input type="file" name="image4" class="form-control" id="image4" required>
        </div>

        <button type="submit" class="btn btn-success">Create Feature</button>
        <a href="{{ route('featureworks.index') }}" class="btn btn-secondary">Back</a>
    </form>
</div>
@endsection
