@extends('layouts.admin.app')

@section('content')
<div class="container mx-auto mt-3">
    <h2>Edit Feature</h2>

    @if($errors->any())
        <div class="alert alert-danger">
            <ul>@foreach($errors->all() as $error)<li>{{ $error }}</li>@endforeach</ul>
        </div>
    @endif

    <form class="w-50 " action="{{ route('featureworks.update', $feature->id) }}" method="POST" enctype="multipart/form-data">
        @csrf
        @method('PUT')

        <div class="mb-3">
            <label for="heading" class="form-label">Heading</label>
            <input type="text" name="heading" class="form-control" id="heading" value="{{ old('heading', $feature->heading) }}" required>
        </div>

        <div class="mb-3">
            <label for="image1" class="form-label">Image1</label>
            <input type="file" name="image1" class="form-control" id="image1">
            @if($feature->image1)
                <img src="{{ asset( $feature->image1) }}" width="100" class="mt-2">
            @endif
        </div>
        <div class="mb-3">
            <label for="image2" class="form-label">Image 2</label>
            <input type="file" name="image2" class="form-control" id="image2">
            @if($feature->image2)
                <img src="{{ asset( $feature->image2) }}" width="100" class="mt-2">
            @endif
        </div>
        <div class="mb-3">
            <label for="image3" class="form-label">Image 3</label>
            <input type="file" name="image3" class="form-control" id="image3">
            @if($feature->image3)
                <img src="{{ asset( $feature->image3) }}" width="100" class="mt-2">
            @endif
        </div>
        <div class="mb-3">
            <label for="image4" class="form-label">Image 4</label>
            <input type="file" name="image4" class="form-control" id="image4">
            @if($feature->image4)
                <img src="{{ asset( $feature->image4) }}" width="100" class="mt-2">
            @endif
        </div>
            @if($feature->image)
                <img src="{{ asset( $feature->image) }}" width="100" class="mt-2">
            @endif
        

        <button type="submit" class="btn btn-success">Update Feature</button>
        <a href="{{ route('featureworks.index') }}" class="btn btn-secondary">Back</a>
    </form>
</div>
@endsection
