@extends('layouts.admin.app')

@section('content')
<div class="container-fluid  mt-3">
    <div class="row">
       <div class="col-6">
    <h2 class="mb-4">Feature Works</h2>
    </div>
    <div class="col-6 d-flex justify-content-end align-items-center">
    <a href="{{ route('featureworks.create') }}" class="btn btn-primary mb-3">Add New Feature</a>
    </div>
    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif
  </div>
    <table class="table table-bordered">
        <thead class="table-dark">
            <tr>
                <th>SR</th>
                <th>Heading</th>
                <th>Image1</th>
                <th>Image2</th>
                <th>Image3</th>
                <th>Image4</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @foreach($features as $feature)
            <tr>
                <td>{{ $loop->iteration }}</td>
                <td>{{ $feature->heading }}</td>
                <td>
                    @if($feature->image1)
                        <img src="{{ asset($feature->image1) }}" width="100">
                    @endif
                </td>
                <td>
                    @if($feature->image2)
                        <img src="{{ asset($feature->image2) }}" width="100">
                    @endif
                </td>
                <td>
                    @if($feature->image3)
                        <img src="{{ asset($feature->image3) }}" width="100">
                    @endif
                </td>
                <td>
                    @if($feature->image4)
                        <img src="{{ asset($feature->image4) }}" width="100">
                    @endif
                </td>
                <td>
                    <a href="{{ route('featureworks.edit', $feature->id) }}" class="btn btn-sm btn-warning">Edit</a>
                    <form action="{{ route('featureworks.destroy', $feature->id) }}" method="POST" style="display:inline-block">
                        @csrf
                        @method('DELETE')
                        <button type="submit" class="btn btn-sm btn-danger" onclick="return confirm('Are you sure?')">Delete</button>
                    </form>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endsection
