@extends('layouts.admin.app')

@section('content')
<div class="container bg-white p-5  mt-5">

    <div class="row">
         <div class="col-6">
    <h1>Let's Talk List</h1>
    </div>
    <div class="col-6 d-flex justify-content-end align-items-center">
    <a href="{{ route('letstalk.create') }}" class="btn btn-primary mb-3">Add New</a>
    </div>
  </div>
    <table class="table table-bordered">
        <thead class="table-dark">
            <tr>
                <th>SR</th>
                <th>Title</th>
                <th>Number</th>
                <th>Number1</th>
                <th>Actions</th>
            </tr>
        </thead>
        <tbody>
            @foreach($letstalks as $item)
                <tr>
                    <td>{{ $loop->iteration }}</td>
                    <td>{{ $item->title }}</td>
                    <td>{{ $item->number }}</td>
                    <td>{{ $item->num1 }}</td>
                    <td>
                        <a href="{{ route('letstalk.edit', $item->id) }}" class="btn btn-sm btn-warning">Edit</a>
                        <form action="{{ route('letstalk.destroy', $item->id) }}" method="POST" style="display:inline-block;">
                            @csrf
                            @method('DELETE')
                            <button class="btn btn-sm btn-danger" onclick="return confirm('Delete?')">Delete</button>
                        </form>
                    </td>
                </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endsection
