@extends('layouts.admin.app')
@section('content')
<section class="content-header">
    <div class="container-fluid w-11/12 mt-3 mx-auto">
        <div class="row mb-2">
            <div class="col-sm-6">
                <h1>Edit Slider</h1>
            </div>
            <div class="col-sm-6 text-right">
                <a href="{{ route('sliders.index') }}" class="btn btn-secondary">Back</a>
            </div>
        </div>
    </div>
</section>

<!-- Main content -->
<section class="content">
    <div class="container-fluid">
        <div class="card">
            <div class="card-body">
                <form action="{{ route('sliders.update', $slider->id) }}" method="POST" enctype="multipart/form-data">
                    @csrf
                    @method('PUT')
                    <div class="mb-3">
                    <label>Current Image:</label><br>
                    @if($slider->image)
                        <img src="{{ asset($slider->image) }}" alt="Slider Image" width="150">
                    @else
                        <p>No image uploaded</p>
                    @endif
                    <br><br>

                    <label>Change Image:</label>
                      <br>
                    <input type="file" name="image">
                    <br>
                    </div>
                    <label>URL:</label>
                    <br>
                    <input type="text" name="url" value="{{ old('url', $slider->url) }}" placeholder="https://example.com">
                    @error('url')
                        <p class="invalid-feedback">{{ $message }}</p>
                    @enderror
                    <br>

                    <div class="pb-5 pt-3">
                        <label>Heading</label>
                        <br>
                        <input type="text" name="heading" value="{{ old('heading', $slider->heading) }}" placeholder="heading">
                        <br>

                        <label>Para</label>
                        <br>
                        <textarea name="para" class="form-control mb-3"  placeholder="Enter paragraph">{{ old('para', $slider->para) }}</textarea>
                        <br>

                        <button class="btn btn-primary">Update</button>
                    </div>

                </form>
            </div>
        </div>
    </div>
</section>
@endsection
