@extends('layouts.admin.app')

@section('content')
<div class="container mt-4">
    <h1>Edit Team Member</h1>
    <form class="w-50 bg-white p-5" action="{{ route('team.update', $team->id) }}" method="POST" enctype="multipart/form-data">
        @csrf @method('PUT')
        <div class="form-group mb-3">
            <label>Heading</label>
            <input type="text" name="heading" value="{{ $team->heading }}" class="form-control">
        </div>
        <div class="form-group mb-3">
            <label>Name</label>
            <input type="text" name="name" value="{{ $team->name }}" class="form-control" required>
        </div>
        <div class="form-group mb-3">
            <label>Designation</label>
            <input type="text" name="designation" value="{{ $team->designation }}" class="form-control" required>
        </div>
        <div class="form-group mb-3">
            <label>Image</label><br>
            @if($team->image)
                <img src="{{ asset('storage/'.$team->image) }}" width="80"><br>
            @endif
            <input type="file" name="image" class="form-control mt-2">
        </div>
        <button type="submit" class="btn btn-primary">Update</button>
        <a href="{{ route('team.index') }}" class="btn btn-secondary "style="color: #fff !important;">Back to List</a>
    </form>
</div>
@endsection
