@extends('layouts.admin.app')

@section('content')
<div class="container mt-4">
    <div class="row">
    <div class="col">
    <h1>Meet With Our Team</h1>
    </div>
    <div class="col text-right">
    <a href="{{ route('team.create') }}" class="btn btn-primary  mb-3">Add New Member</a>
    </div>
    </div>
    @if(session('success'))
    <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <table class="table table-bordered ">
        <thead class="bg-dark">
            <tr>
                <th>SR</th>
                <th>Heading</th>
                <th>Name</th>
                <th>Designation</th>
                <th>Image</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
            @foreach($teams as $team)
            <tr>
                <td>{{$loop->iteration }}</td>
                <td>{{ $team->heading }}</td>
                <td>{{ $team->name }}</td>
                <td>{{ $team->designation }}</td>
                <td>
                    @if($team->image && file_exists(public_path($team->image)))
                    <img src="{{ asset($team->image) }}" alt="{{ $team->name }}" width="50">
                    @else
                    <img src="{{ asset('default.png') }}" alt="No image" width="50">
                    @endif
                </td>
                <td>
                    <a href="{{ route('team.edit', $team->id) }}" class="btn btn-sm btn-info">Edit</a>
                    <form action="{{ route('team.destroy', $team->id) }}" method="POST" style="display:inline-block;">
                        @csrf @method('DELETE')
                        <button type="submit" class="btn btn-sm btn-danger"
                            onclick="return confirm('Delete this member?')">Delete</button>
                    </form>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endsection