@extends('layouts.admin.app')

@section('content')
<div class="container mt-4">
    <div class="w-50 bg-white p-5">
    <h1>Edit Testimonial</h1>
    <form action="{{ route('testimonials.update', $testimonial->id) }}" method="POST" enctype="multipart/form-data">
        @csrf
        @method('PUT')

        <label>Heading</label>
        <input type="text" name="heading" value="{{ $testimonial->heading }}" class="form-control mb-3">

        <label>Description</label>
        <textarea name="description" class="form-control mb-3">{{ $testimonial->description }}</textarea>

        <label>Name</label>
        <input type="text" name="name" value="{{ $testimonial->name }}" class="form-control mb-3">

        <label>Paragraph</label>
        <textarea name="paragraph" class="form-control mb-3">{{ $testimonial->paragraph }}</textarea>

        <label>Image</label>
        <input type="file" name="image" class="form-control mb-3">
        @if($testimonial->image)
            <img src="{{ url('storage/'.$testimonial->image) }}" width="100" class="mb-3">
        @endif
        <br>
        <label>Image1</label>
        <input type="file" name="image1" class="form-control mb-3">
        @if($testimonial->image1)
            <img src="{{ url('storage/'.$testimonial->image1) }}" width="100" class="mb-3">
        @endif

        <label>Star</label>
        <input type="text" name="star" value="{{ $testimonial->star }}" class="form-control mb-3">

        <button type="submit" class="btn btn-success">Update</button>
        <a href="{{route('testimonials.index')}}" class="btn btn-secondary" style="color: #fff !important;" > Back To List </a>
    </form>
</div>
</div>
@endsection
