@extends('layouts.admin.app')

@section('content')
<div class="container-fluid mt-4 overflow-auto bg-white p-3">
    <div class="row">
        <div class="col">
            <h1>Testimonials List</h1>
        </div>
        <div class="col text-right">
            <a href="{{ route('testimonials.create') }}" class="btn btn-primary mb-3">Add New</a>
        </div>
    </div>

    @if(session('success'))
        <div class="alert alert-success">{{ session('success') }}</div>
    @endif

    <table class="table table-bordered">
        <thead class="table-dark">
            <tr>
                <th>SR</th>
                <th>Heading</th>
                <th>Description</th>
                <th>Name</th>
                <th>Paragraph</th>
                <th>Image</th>
                <th>Image1</th>
                <th>Rating</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
            @foreach($testimonials as $testimonial)
            <tr>
                <td>{{ $loop->iteration }}</td>
                <td>{{ $testimonial->heading }}</td>
                <td>{{ $testimonial->description }}</td>
                <td>{{ $testimonial->name }}</td>
                <td>{{ $testimonial->paragraph }}</td>
                <td>
                    @if($testimonial->image)
                        <img src="{{ asset($testimonial->image) }}" width="80">
                    @endif
                </td>
                <td>
                    @if($testimonial->image1)
                        <img src="{{ asset($testimonial->image1) }}" width="80">
                    @endif
                </td>
                
                <td>{{ $testimonial->star }}</td>

                <td>
                    <a href="{{ route('testimonials.edit', $testimonial->id) }}" class="btn btn-sm btn-info">Edit</a>
                    <form action="{{ route('testimonials.destroy', $testimonial->id) }}" method="POST" style="display:inline-block;">
                        @csrf @method('DELETE')
                        <button type="submit" class="btn btn-sm btn-danger"
                                onclick="return confirm('Delete this testimonial?')">Delete</button>
                    </form>
                </td>
            </tr>
            @endforeach
        </tbody>
    </table>
</div>
@endsection
