<?php

use Illuminate\Support\Facades\Route;
use App\Http\Controllers\SliderController;
use App\Http\Controllers\IndexController;
use App\Http\Controllers\AuthController;
use App\Http\Controllers\AboutUsController;
use App\Http\Controllers\LetsTalkController;
use App\Http\Controllers\TestimonialController;
use App\Http\Controllers\TeamController;
use App\Http\Controllers\FeatureWorkController;
use App\Http\Controllers\ContactUsController;

// -------- PUBLIC HOME PAGE --------
Route::get('/', [IndexController::class, 'index'])->name('index');

// -------- AUTH ROUTES (guest only) --------
Route::middleware('guest')->group(function () {

    Route::get('/login', [AuthController::class, 'showLogin'])->name('login');
    Route::post('/login', [AuthController::class, 'login'])->name('login.submit');

    

    Route::get('/register', [AuthController::class, 'showRegister'])->name('register');
    Route::post('/register', [AuthController::class, 'register'])->name('register.submit');
});

// -------- ADMIN / SLIDER ROUTES (protected) --------
Route::middleware('auth')->group(function () {
    Route::get('/sliders', [SliderController::class, 'index'])->name('sliders.index');
    Route::get('/sliders/create', [SliderController::class, 'create'])->name('sliders.create');
    Route::post('/sliders/store', [SliderController::class, 'store'])->name('sliders.store');
    Route::delete('/sliders/{id}', [SliderController::class, 'destroy'])->name('sliders.destroy');
    Route::get('/sliders/{id}/edit', [SliderController::class, 'edit'])->name('sliders.edit');   // ✅ EDIT route
    Route::put('/sliders/{id}', [SliderController::class, 'update'])->name('sliders.update');   // ✅ UPDATE route
    

    Route::get('/aboutus', [AboutUsController::class, 'index'])->name('aboutus.index');           // list
    Route::get('/aboutus/create', [AboutUsController::class, 'create'])->name('aboutus.create');
    Route::post('/aboutus/store', [AboutUsController::class, 'store'])->name('aboutus.store'); // ← POST route
    Route::get('/aboutus/{id}/edit', [AboutUsController::class, 'edit'])->name('aboutus.edit');
    Route::put('/aboutus/{id}', [AboutUsController::class, 'update'])->name('aboutus.update');
    Route::delete('/aboutus/{id}', [AboutUsController::class, 'destroy'])->name('aboutus.destroy');

        // LET'S TALK CRUD (RESOURCE ROUTES)
    Route::get('/letstalk', [LetsTalkController::class, 'index'])->name('letstalk.index');
    Route::get('/letstalk/create', [LetsTalkController::class, 'create'])->name('letstalk.create');
    Route::post('/letstalk/store', [LetsTalkController::class, 'store'])->name('letstalk.store');
    Route::get('/letstalk/{id}/edit', [LetsTalkController::class, 'edit'])->name('letstalk.edit');
    Route::put('/letstalk/{id}', [LetsTalkController::class, 'update'])->name('letstalk.update');
    Route::delete('/letstalk/{id}', [LetsTalkController::class, 'destroy'])->name('letstalk.destroy');

   // Show all testimonials
    Route::get('/testimonials', [TestimonialController::class, 'index'])->name('testimonials.index');
    Route::get('/testimonials/create', [TestimonialController::class, 'create'])->name('testimonials.create');
    Route::post('/testimonials', [TestimonialController::class, 'store'])->name('testimonials.store');
    Route::get('/testimonials/{id}/edit', [TestimonialController::class, 'edit'])->name('testimonials.edit');
    Route::put('/testimonials/{id}', [TestimonialController::class, 'update'])->name('testimonials.update');
    Route::delete('/testimonials/{id}', [TestimonialController::class, 'destroy'])->name('testimonials.destroy');

    // TEAM MEMBER ROUTES
    Route::get('/team', [TeamController::class, 'index'])->name('team.index');
    Route::get('/team/create', [TeamController::class, 'create'])->name('team.create');
    Route::post('/team', [TeamController::class, 'store'])->name('team.store');
    Route::get('/team/{id}/edit', [TeamController::class, 'edit'])->name('team.edit');
    Route::put('/team/{id}', [TeamController::class, 'update'])->name('team.update');
    Route::delete('/team/{id}', [TeamController::class, 'destroy'])->name('team.destroy');

    // FEATURE WORK ROUTES
    Route::get('/featureworks', [FeatureWorkController::class, 'index'])->name('featureworks.index');
    Route::get('/featureworks/create', [FeatureWorkController::class, 'create'])->name('featureworks.create');
    Route::post('/featureworks', [FeatureWorkController::class, 'store'])->name('featureworks.store');
    Route::get('/featureworks/{id}/edit', [FeatureWorkController::class, 'edit'])->name('featureworks.edit');
    Route::put('/featureworks/{id}', [FeatureWorkController::class, 'update'])->name('featureworks.update');
    Route::delete('/featureworks/{id}', [FeatureWorkController::class, 'destroy'])->name('featureworks.destroy');

    // CONTACT ROUTES
Route::get('/contactus', [ContactUsController::class, 'index'])->name('contactus.index');
Route::get('/contactus/create', [ContactUsController::class, 'create'])->name('contactus.create');
Route::get('/contactus/{id}', [ContactUsController::class, 'show'])->name('contactus.show'); // fix capitalization
Route::post('/contactus', [ContactUsController::class, 'store'])->name('contactus.store');
Route::get('/contactus/{id}/edit', [ContactUsController::class, 'edit'])->name('contactus.edit');
Route::put('/contactus/{id}', [ContactUsController::class, 'update'])->name('contactus.update');
Route::delete('/contactus/{id}', [ContactUsController::class, 'destroy'])->name('contactus.destroy');

    // Logout route
    Route::post('/logout', [AuthController::class, 'logout'])->name('logout');
});

use Illuminate\Support\Facades\Artisan;

Route::get('/clear-all', function () {
    Artisan::call('config:clear');
    Artisan::call('cache:clear');
    Artisan::call('route:clear');
    Artisan::call('view:clear');
    Artisan::call('config:cache');
    return '✅ Cache Cleared';
});
