

<?php $__env->startSection('content'); ?>
<div class="container mt-4">
    <div class="row">
    <div class="col">
    <h1>Meet With Our Team</h1>
    </div>
    <div class="col text-right">
    <a href="<?php echo e(route('team.create')); ?>" class="btn btn-primary  mb-3">Add New Member</a>
    </div>
    </div>
    <?php if(session('success')): ?>
    <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <table class="table table-bordered ">
        <thead class="bg-dark">
            <tr>
                <th>SR</th>
                <th>Heading</th>
                <th>Name</th>
                <th>Designation</th>
                <th>Image</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $teams; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $team): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($loop->iteration); ?></td>
                <td><?php echo e($team->heading); ?></td>
                <td><?php echo e($team->name); ?></td>
                <td><?php echo e($team->designation); ?></td>
                <td>
                    <?php if($team->image && file_exists(public_path($team->image))): ?>
                    <img src="<?php echo e(asset($team->image)); ?>" alt="<?php echo e($team->name); ?>" width="50">
                    <?php else: ?>
                    <img src="<?php echo e(asset('default.png')); ?>" alt="No image" width="50">
                    <?php endif; ?>
                </td>
                <td>
                    <a href="<?php echo e(route('team.edit', $team->id)); ?>" class="btn btn-sm btn-info">Edit</a>
                    <form action="<?php echo e(route('team.destroy', $team->id)); ?>" method="POST" style="display:inline-block;">
                        <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                        <button type="submit" class="btn btn-sm btn-danger"
                            onclick="return confirm('Delete this member?')">Delete</button>
                    </form>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('layouts.admin.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\om\resources\views/admin/team/list.blade.php ENDPATH**/ ?>