

<?php $__env->startSection('content'); ?>
<div class="container py-4">
    <div class="d-flex justify-content-between align-items-center mb-3">
        <h2>Contacts</h2>
        <a href="<?php echo e(route('contacts.create')); ?>" class="btn btn-primary">New Contact</a>
    </div>

    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <?php if($contacts->count()): ?>
    <table class="table table-bordered">
        <thead>
            <tr>
                <th>#</th>
                <th>Name</th>
                <th>Address</th>
                <th>Email</th>
                <th>Phone</th>
                <th width="160">Actions</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $contacts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $contact): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($loop->iteration + ($contacts->currentPage()-1)*$contacts->perPage()); ?></td>
                <td><?php echo e($contact->name); ?></td>
                <td><?php echo e($contact->addres); ?></td>
                <td><?php echo e($contact->email); ?></td>
                <td><?php echo e($contact->phone); ?></td>
                <td>
                    <a href="<?php echo e(route('contacts.show', $contact)); ?>" class="btn btn-sm btn-info">View</a>
                    <a href="<?php echo e(route('contacts.edit', $contact)); ?>" class="btn btn-sm btn-warning">Edit</a>
                    <form action="<?php echo e(route('contacts.destroy', $contact)); ?>" method="POST" class="d-inline" onsubmit="return confirm('Delete this contact?');">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button class="btn btn-sm btn-danger">Delete</button>
                    </form>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <?php echo e($contacts->links()); ?>

    <?php else: ?>
        <div class="alert alert-secondary">No contacts yet.</div>
    <?php endif; ?>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\om\resources\views/admin/contacts/index.blade.php ENDPATH**/ ?>