

<?php $__env->startSection('content'); ?>
<div class="container-fluid mt-4 overflow-auto bg-white p-3">
    <div class="row">
        <div class="col">
            <h1>Testimonials List</h1>
        </div>
        <div class="col text-right">
            <a href="<?php echo e(route('testimonials.create')); ?>" class="btn btn-primary mb-3">Add New</a>
        </div>
    </div>

    <?php if(session('success')): ?>
        <div class="alert alert-success"><?php echo e(session('success')); ?></div>
    <?php endif; ?>

    <table class="table table-bordered">
        <thead class="table-dark">
            <tr>
                <th>SR</th>
                <th>Heading</th>
                <th>Description</th>
                <th>Name</th>
                <th>Paragraph</th>
                <th>Image</th>
                <th>Image1</th>
                <th>Rating</th>
                <th>Action</th>
            </tr>
        </thead>
        <tbody>
            <?php $__currentLoopData = $testimonials; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $testimonial): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($loop->iteration); ?></td>
                <td><?php echo e($testimonial->heading); ?></td>
                <td><?php echo e($testimonial->description); ?></td>
                <td><?php echo e($testimonial->name); ?></td>
                <td><?php echo e($testimonial->paragraph); ?></td>
                <td>
                    <?php if($testimonial->image): ?>
                        <img src="<?php echo e(asset($testimonial->image)); ?>" width="80">
                    <?php endif; ?>
                </td>
                <td>
                    <?php if($testimonial->image1): ?>
                        <img src="<?php echo e(asset($testimonial->image1)); ?>" width="80">
                    <?php endif; ?>
                </td>
                
                <td><?php echo e($testimonial->star); ?></td>

                <td>
                    <a href="<?php echo e(route('testimonials.edit', $testimonial->id)); ?>" class="btn btn-sm btn-info">Edit</a>
                    <form action="<?php echo e(route('testimonials.destroy', $testimonial->id)); ?>" method="POST" style="display:inline-block;">
                        <?php echo csrf_field(); ?> <?php echo method_field('DELETE'); ?>
                        <button type="submit" class="btn btn-sm btn-danger"
                                onclick="return confirm('Delete this testimonial?')">Delete</button>
                    </form>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('layouts.admin.app', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\xampp\htdocs\om\resources\views/admin/testimonial/list.blade.php ENDPATH**/ ?>