<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Hash;
use App\Models\Doctor;

class DoctorAuthController extends Controller
{
    public function showLoginForm()
    {
        return view('admin.login');
    }

   public function login(Request $request)
{
    $request->validate([
        'contactNumber' => 'required',
        'password' => 'required|min:6',
    ]);

$doctor = Doctor::where('countryCode', $request->countryCode)
                    ->where('contactNumber', $request->contactNumber)
                    ->first();

    

   if (!$doctor) {
        // Phone number not registered
        return back()->with('login_error', 'This phone number is not registered with us. Please use the correct phone number.');
    }

    if (!Hash::check($request->password, $doctor->password)) {
        // Wrong password
        return back()->with('login_error', 'Incorrect password. Please try again.');
    }


    Auth::guard('doctor')->login($doctor);

// ✅ Pass success toast message
return redirect()->route('admin.index')->with('login_success', 'login successfull 👋');

}



    public function logout(Request $request)
{
    
    Auth::guard('doctor')->logout();

    
    $request->session()->invalidate();
    $request->session()->regenerateToken();


    return redirect()->route('doctor.login');
}

public function showForgotPasswordForm()
{
    return view('admin.forgot_password');
}

// Handle sending OTP
// DoctorAuthController.php
public function sendOtp(Request $request)
{
    $request->validate([
        'contactNumber' => 'required',
        'countryCode' => 'required',
    ]);

    $doctor = Doctor::where('countryCode', $request->countryCode)
                    ->where('contactNumber', $request->contactNumber)
                    ->first();

    if (!$doctor) {
        return back()->with('login_error', 'This phone number is not registered with us.');
    }

   
    $otp = rand(1000, 9999); // 4-digit OTP


    session([
        'otp' => $otp,
        'doctor_reset_id' => $doctor->id
    ]);

    
    return redirect()->route('doctor.verify.otp')->with('login_info', "Your OTP is: $otp");
}

// Show OTP Page
public function showOtpForm()
{
    return view('admin.varifyotp');
}

// Verify OTP
public function verifyOtp(Request $request)
{
    $request->validate([
        'otp.*' => 'required|digits:1', // Each input is 1 digit
    ]);

    $inputOtp = implode('', $request->otp);

    if ($inputOtp != session('otp')) {
        return back()->with('login_error', 'Invalid OTP. Please try again.');
    }

    // OTP correct → redirect to password reset
    return redirect()->route('doctor.reset.password.form');
}

public function showResetPasswordForm()
{
    return view('admin.resetpasssword');
}

public function resetPassword(Request $request)
{
    $request->validate([
        'password' => 'required|min:6|confirmed' // confirmed checks password_confirmation
    ]);

    $doctorId = session('doctor_reset_id');
    $doctor = Doctor::find($doctorId);


    if (!$doctor) {
        return redirect()->route('doctor.login')->with('login_error', 'Session expired. Please try again.');
    }

    $doctor->password = Hash::make($request->password);
    $doctor->save();

    // Clear OTP session
    session()->forget(['otp', 'doctor_reset_id']);

    return redirect()->route('doctor.login')->with('login_info', 'Password reset successfully! You can login now.');
}


}

