<?php

namespace App\Mail;
 
use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable; 
use Illuminate\Queue\SerializesModels;
use App\Models\PatientsMedicalReport;

class MedicalReportMail extends Mailable
{
    use Queueable, SerializesModels;

    public $report;

    public function __construct(PatientsMedicalReport $report,$patient, $pdfPath = null,$doctor_email,$doctor_name)
    {
         $this->report = $report;
         $this->pdfPath = $pdfPath;
         $this->patient = $patient;
         $this->doctorEmail = $doctor_email;
        $this->doctorName = $doctor_name;
    }

    
    public function build()
    {
        
        

        $mail = $this->from(config('mail.from.address'), config('mail.from.name'))
        ->replyTo($this->doctorEmail, $this->doctorName)
            ->subject('Medical Report')
            ->markdown('emails.medicalreport')
            ->with([
                'report' => $this->report,
                'patient' => $this->patient,
            ]);

        // ✅ Attach PDF if available
        if ($this->pdfPath && file_exists($this->pdfPath)) {
            $mail->attach($this->pdfPath, [
                'as'   => 'MedicalReport.pdf',
                'mime' => 'application/pdf',
            ]);
        }

        return $mail;
    }
}
