<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use App\Models\PatientsRefferal; 
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class ReferralMail extends Mailable
{
    use Queueable, SerializesModels;

    public $referral;
    public $pdfPath;

    public function __construct(PatientsRefferal $referral, $patient, $pdfPath = null,$doctor_email,$doctor_name)
    {
        $this->referral = $referral;
       $this->pdfPath = $pdfPath;
        $this->patient = $patient;
        $this->doctorEmail = $doctor_email;
        $this->doctorName = $doctor_name;
    }

    public function build()
    {
        $mail = $this->from(config('mail.from.address'), config('mail.from.name'))
                     ->replyTo($this->doctorEmail, $this->doctorName)
                     ->subject('Referral Report')
                     ->markdown('emails.referral')
                     ->with(['referral' => $this->referral,'patient' => $this->patient,]);

        if ($this->pdfPath && file_exists($this->pdfPath)) {
            $mail->attach($this->pdfPath, [
                'as' => 'Referral.pdf',
                'mime' => 'application/pdf',
            ]);
        }

        return $mail;
    }
}