<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use App\Models\SickNote; 
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class SickNoteMail extends Mailable
{
    use Queueable, SerializesModels;

    public $note;
    public $pdfPath;

    public function __construct(SickNote $note,$patient, $pdfPath = null,$doctor_email,$doctor_name)
    {
        $this->note = $note;
        $this->pdfPath = $pdfPath;
        $this->doctorEmail = $doctor_email;
        $this->doctorName = $doctor_name;
        $this->patient = $patient;
    }

    public function build()
    {
        $mail = $this->from(config('mail.from.address'), config('mail.from.name'))
        ->replyTo($this->doctorEmail, $this->doctorName)
            ->markdown('emails.sicknote')
            ->with(['note' => $this->note,'patient' => $this->patient]);

        if ($this->pdfPath && file_exists($this->pdfPath)) {
            $mail->attach($this->pdfPath, [
                'as' => 'SickNote.pdf',
                'mime' => 'application/pdf',
            ]);
        }

        return $mail;
    }
}
