<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;
use App\Models\tbl_patient;
use App\Models\tbl_family_members;

class ConsultRequest extends Model
{
    protected $table = 'consult_requests';

    protected $fillable = [
        'patient_id',
        'doctor_id',
        'medical_problem_id',
        'canton',
        'language',
    ];

    protected $casts = [
        'created_at' => 'datetime',
        'updated_at' => 'datetime',
    ];

    // ❌ DO NOT USE belongsTo for patient directly

    /**
     * Get patient or family member dynamically
     */
    public function getPatientDetailsAttribute()
    {
        // First check in tbl_patient
        $patient = tbl_patient::find($this->patient_id);

        if ($patient) {
            $patient->type = 'patient';
            return $patient;
        }

        // Else check in tbl_family_members
        $familyMember = tbl_family_members::find($this->patient_id);

        if ($familyMember) {
            $familyMember->type = 'family';
            return $familyMember;
        }

        return null;
    }

    public function doctor()
{
    return $this->belongsTo(\App\Models\Doctor::class, 'doctor_id');
}

 public function medicalProblem()
    {
        return $this->belongsTo(main_complaint::class, 'medical_problem_id');
    }
}
