<!DOCTYPE html>
<html lang="en">

<head>
  <meta charset="UTF-8" />
  <meta name="viewport" content="width=device-width, initial-scale=1.0" />
  <title>Modal Centered</title>
  <style>
    .modal-overlay {
      position: fixed;
      top: 0;
      left: 0;
      height: 100vh;
      width: 100vw;
      background: rgba(0, 0, 0, 0.7);
      display: flex;
      align-items: center;
      justify-content: center;
      z-index: 1000;
    }


    .modal-content {
      background: #fff;
      border-radius: 12px;
      padding: 20px;
      width: 90%;
      max-width: 600px;
      box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
    }

    .modal-header {
      display: flex;
      justify-content: space-between;
      align-items: center;
      margin-bottom: 10px;
    }

    .modal-header h2 {
      margin: 0;
      font-size: 18px;
    }

    .close-btn {
      font-size: 22px;
      background: none;
      border: none;
      cursor: pointer;
      color: #333;
    }

    .modal-body {
      max-height: 400px;
      overflow-y: auto;
    }

    .modal-body img {
      width: 100%;
      display: block;
      border-radius: 8px;
    }
  </style>
</head>

<body>


  <div class="modal-overlay" id="imageModal">
    <div class="modal-content">
      <div class="modal-header">
        <h2>Appointment Images</h2>
        <button class="close-btn" onclick="closeModal()">&times;</button>
      </div>
      <div class="modal-body">
        <img src="Assets/healt_issues_img.jpg" alt="Health Insurance">
      </div>
    </div>
  </div>


 <script>
  function closeModal() {
    document.getElementById("imageModal").style.display = "none";
    window.location.href = "referral.html";
  }
  
</script>

</body>

</html>