<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Quickmed</title>
    <link href="https://cdn.jsdelivr.net/npm/remixicon@3.5.0/fonts/remixicon.css" rel="stylesheet">
    <link rel="stylesheet" href="style.css" />
    <link rel="shortcut icon" href="Assets/Fav-icon.png" type="image/x-icon">
</head>

<body>
    <div class="container">

        <aside class="sidebar">
            <div class="logo-section">
                <img src="Assets/sidebar-logo.png" alt="QuickMed Logo">
                <hr>
            </div>
            <nav class="menu">
                <a href="index.html" class="active">
                    <i class="ri-user-line"></i> Patients
                </a>

            </nav>
            <div class="logout">

                <a href="logout.html">
                    <img src="Assets/logout.svg" alt="log-out"> Log Out
                </a>
            </div>
        </aside>

        <div class="right-page">
            <div class="header-row">
                <div class="header-left">
                    <i class="ri-menu-line sidebar-toggle"></i>
                    <h1>Patients</h1>
                </div>

                <div style="display: flex; align-items: center; gap: 10px;">
                    <img src="Assets/premium_photo-1661508620175-3ae20da61cda.jpeg" alt="Profile" class="profile-img"
                        style="width: 40px; height: 40px; border-radius: 50%;">

                    <div style="display: flex; flex-direction: column; line-height: 1.2;">
                        <span style="font-weight: bold;">James Miller</span>
                        <span style="font-size: 12px; color: #999999;">Doctor</span>
                    </div>
                </div>
            </div>

            <hr>
            <div class="tabs-search">
                <!-- <div class="tabs-wrapper">
                    <div class="tabs">
                        <a href="index.html" class="tab active">Allergies</a>
                        <a href="approved.html" class="tab">Medical</a>
                        <a href="rejected.html" class="tab">Medications</a>
                    </div>
                </div> -->

                <!-- <div class="search-box">
                    <input type="text" placeholder="Search">
                    <i class="ri-search-line"></i>
                </div> -->

            </div>




            <div class="header-row">

                <!-- Left Section -->
                 <div class="addprescription">
                    <a class="back-btn" href="index.html">
                        <i class="ri-arrow-left-line"></i>
                    </a>
                    <h1>Add Prescription</h1>
                </div>

                <!-- Right Section -->
                <div class="Health">
                    <a href="health_Insurance.html"> <button class="btn-custom">Health Insurance</button></a>
                    <a href="appointment_Images.html"><button class="btn-custom">Appointment Images</button></a>
                </div>

            </div>

            <div class="profile-card">
                <div class="profile-header">
                    <img src="Assets/OIP.webp" alt="Profile" class="profile-pic">
                    <div>
                        <h3 class="name">Emily Johnson</h3>
                        <p class="location"><span class="icon">📍</span> Switzerland</p>
                    </div>
                </div>
                <hr>
                <div class="details-grid">
                    <div class="detail"><strong>Email</strong><br><span>Frederic.andre@ehc.vd.ch</span></div>
                    <div class="detail"><strong>Contact No.</strong><br><span>41 791391424</span></div>
                    <div class="detail"><strong>DOB</strong><br><span>1972-11-25</span></div>
                    <div class="detail"><strong>Gender</strong><br><span>Male</span></div>
                    <div class="detail"><strong>AVS Number</strong><br><span>N/A</span></div>
                    <div class="detail"><strong>Insurance No.</strong><br><span>N/A</span></div>
                    <div class="detail"><strong>Canton</strong><br><span>VD</span></div>
                    <div class="detail"><strong>Date of Consult</strong><br><span>06 May, 2025</span></div>
                    <div class="detail"><strong>Language</strong><br><span>French</span></div>
                </div>
            </div>






            <div class="consult-section">
                <div class="header-bar">
                    <a href="add_prescription.html">
                        <span class="back-arrow"><i class="ri-arrow-left-s-line"></i></span>
                        <span class="header-title">New Consult</span>
                    </a>
                </div>



                <!-- <div class="tab-menu">
                    <button class="tab active">Medical Report</button>
                    <button class="tab">Prescription</button>
                    <button class="tab">Referral</button>
                    <button class="tab">Sick Note</button>
                </div> -->


                <div class="tabs-search" style="padding-top: 24px ;">
                    <div class="tabs-wrapper" style="width: 100%;" >
                        <div class="tabs">
                            <a href="mdical_reports.html" class="tab active">Medical Report</a>
                            <a href="prescription.html" class="tab">Prescription</a>
                            <a href="referral.html" class="tab">Referral</a>
                            <a href="sick_note.html" class="tab">Sick Note</a>
                        </div>
                    </div>
                </div>


                <div class="consult-form">
                    <div class="form-row">
                        <div class="form-group">
                            <label for="consult-date">Date of Consult</label>
                            <input type="text" id="consult-date" class="input-box" />
                        </div>
                        <div class="form-group">
                            <label for="consult-time">Time</label>
                            <select id="consult-time" class="input-box-time">
                                <option></option>
                                <option>5 Minutes</option>
                                <option>10 Minutes</option>
                                <option>15 Minutes</option>
                                <option>20 Minutes</option>
                                <option>25 Minutes</option>
                            </select>
                        </div>
                    </div>

                    <div class="form-row">
                        <div class="form-group">
                            <label for="diagnosis">Diagnosis</label>
                            <textarea id="diagnosis" class="input-box" rows="4"></textarea>
                        </div>
                        <div class="form-group">
                            <label for="anamnesis">Current anamnesis</label>
                            <textarea id="anamnesis" class="input-box" rows="4"></textarea>
                        </div>
                    </div>

                    <div class="form-row">
                        <div class="form-group">
                            <label for="diagnosis">Treatment</label>
                            <textarea id="diagnosis" class="input-box" rows="4"></textarea>
                        </div>
                        <div class="form-group">
                            <label for="anamnesis">Plan</label>
                            <textarea id="anamnesis" class="input-box" rows="4"></textarea>
                        </div>
                    </div>

                    <div class="form-row">
                        <div class="form-group">
                            <label for="diagnosis">Comorbidities</label>
                            <textarea id="diagnosis" class="input-box" rows="4"></textarea>
                        </div>
                        <div class="form-group">
                            <label for="anamnesis">Usual Treatment</label>
                            <textarea id="anamnesis" class="input-box" rows="4"></textarea>
                        </div>
                    </div>

                    <div class="form-row">
                        <div class="form-group">
                            <label for="diagnosis">Allergies</label>
                            <textarea id="diagnosis" class="input-box"  rows="4"></textarea>
                        </div>

                    </div>



                    <div class="Health">
                        <button class="btn-custom" style="width: 180px;">Preview</button>
                    </div>

                </div>


            </div>








        </div>


    </div>

    <div class="overlay"></div>



    <script>
        const toggleBtn = document.querySelector('.sidebar-toggle');
        const sidebar = document.querySelector('.sidebar');
        const overlay = document.querySelector('.overlay');

        toggleBtn.addEventListener('click', () => {
            sidebar.classList.toggle('open');
            overlay.style.display = sidebar.classList.contains('open') ? 'block' : 'none';
        });

        overlay.addEventListener('click', () => {
            sidebar.classList.remove('open');
            overlay.style.display = 'none';
        });
    </script>

</body>

</html>