<x-guest-layout>
@push('styles')
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/intl-tel-input/17.0.19/css/intlTelInput.css" />
@endpush

<style>
.toast-error {
    position: fixed;
    top: 20px;
    right: 20px;
    background: #fff;
    color: #333;
    padding: 14px 20px;
    border-radius: 6px;
    border-left: 5px solid #f44336;
    box-shadow: 0px 4px 10px rgba(0,0,0,0.15);
    display: flex;
    align-items: center;
    gap: 10px;
    z-index: 9999;
    animation: fadeIn 0.4s ease;
    transition: all 0.4s ease;
    min-width: 300px;
    max-width: 350px;
}
.toast-error .icon { color: #f44336; font-size: 18px; }
.toast-error .close-btn {
    margin-left: auto;
    background: transparent;
    border: none;
    color: #555;
    font-size: 18px;
    cursor: pointer;
}
@keyframes fadeIn { from {opacity:0;transform:translateY(-20px);} to {opacity:1;transform:translateY(0);} }
.error-text { color: #f44336; font-size: 14px; margin-top: 1px; display:block; }

/* OTP input styles */
.otp-inputs {
    display: flex;
    justify-content: center;
    gap: 12px;
    margin: 20px 0;
}
.otp-inputs input {
    width: 60px;
    height: 60px;
    text-align: center;
    font-size: 20px;
    border: 1px solid #ccc;
    border-radius: 8px;
}
.otp-inputs input:focus {
    outline: 2px solid #007bff;
    border-color: #007bff;
}
</style>
@if (session('login_info'))
    <div style="color: green; font-weight: bold; margin-bottom: 10px;">
        {{ session('login_info') }}
    </div>
@endif

@if (session('login_error'))
    <div style="color: red; font-weight: bold; margin-bottom: 10px;">
        {{ session('login_error') }}
    </div>
@endif

<div class="container">
    <!-- Left side -->
    <div class="left-side">
        <img src="{{ asset('Assets/login.png') }}" alt="Background" />
    </div>

    <!-- Right side -->
    <div class="right-side">
        <div class="logo">
            <img src="{{ asset('Assets/logo.png') }}" alt="Logo">
        </div>

        <h2>Verification Code</h2>
        <p>Enter the 4-digit code sent to your mobile number</p>

        <form method="POST" action="{{ route('doctor.verify.otp') }}">
            @csrf
            <div class="otp-inputs">
                <input type="text" maxlength="1" name="otp[]" required>
                <input type="text" maxlength="1" name="otp[]" required>
                <input type="text" maxlength="1" name="otp[]" required>
                <input type="text" maxlength="1" name="otp[]" required>
            </div>

            @error('otp')
                <span class="error-text">{{ $message }}</span>
            @enderror
 <p style="text-align: right; margin-bottom: 15px;">
            <a href="{{ route('doctor.login') }}" style="color: #007bff; text-decoration: underline;">← Back to Login</a>
        </p>
            <button type="submit" class="login-btn">Verify</button>
        </form>

        <p style="margin-top:15px;">Didn’t receive OTP? <a href="#">Resend</a></p>

        @if(session('login_error'))
            <div id="toast" class="toast-error">
                <span class="icon">⚠️</span>
                <span>{{ session('login_error') }}</span>
                <button class="close-btn" onclick="document.getElementById('toast').style.display='none'">×</button>
            </div>
        @endif
    </div>
</div>

<script>
// Auto move to next field
document.querySelectorAll('.otp-inputs input').forEach((input, index, inputs) => {
    input.addEventListener('input', () => {
        if (input.value.length === 1 && index < inputs.length - 1) {
            inputs[index + 1].focus();
        }
    });
    input.addEventListener('keydown', e => {
        if (e.key === "Backspace" && !input.value && index > 0) {
            inputs[index - 1].focus();
        }
    });
});

// Toast auto hide
setTimeout(() => {
    const toast = document.getElementById('toast');
    if (toast) {
        toast.style.opacity = "0";
        toast.style.transform = "translateY(-20px)";
        setTimeout(() => toast.remove(), 500);
    }
}, 5000);
</script>
</x-guest-layout>
