<x-guest-layout>

<link href="https://cdn.jsdelivr.net/npm/remixicon@3.5.0/fonts/remixicon.css" rel="stylesheet">
    <link rel="stylesheet" href="{{ asset('style.css') }}" />
    <link rel="shortcut icon" href="{{ asset('Assets/Fav-icon.png') }}" type="image/x-icon">

    <div class="container">
        <!-- Left side -->
        <div class="left-side">
            <img src="{{ asset('Assets/login.png') }}" alt="Medical background" />
        </div>

        <!-- Right side (Login Form) -->
        <div class="right-side">
            <div class="logo">
                <img src="{{ asset('Assets/logo.png') }}" alt="">
            </div>

            <h2>Welcome Back!</h2>
            <p>Please enter the details below to continue</p>

            <!-- Laravel Login Form -->
            <form method="POST" action="{{ route('login') }}">
                @csrf

                <!-- Mobile Number -->
                <label for="phone">Mobile Number</label>
                <div class="input-group">
                    <div class="country-box">
                        <div class="flag-dropdown">
                            <img src="https://flagcdn.com/16x12/ch.png" alt="Flag">
                            <span class="arrow">▼</span>
                        </div>
                        <div class="divider"></div>
                        <div class="country-code">+91</div> <!-- You can set dynamic -->
                    </div>
                    <input type="text" id="phone" name="phone" placeholder="Enter Mobile Number" value="{{ old('phone') }}" required autofocus />
                </div>
                <x-input-error :messages="$errors->get('phone')" class="mt-2" />

                <!-- Password -->
                <label for="password">Password</label>
                <div class="input-password">
                    <input type="password" id="password" name="password" required autocomplete="current-password" />
                    <i class="ri-eye-line toggle-password" id="toggleIcon"></i>
                </div>
                <x-input-error :messages="$errors->get('password')" class="mt-2" />

                <div class="forgot">
                    <a href="{{ route('password.request') }}">Forgot Password?</a>
                </div>

                <button type="submit" class="login-btn">Log In</button>
            </form>
        </div>
    </div>

    <script>
        const passwordInput = document.getElementById("password");
        const toggleIcon = document.getElementById("toggleIcon");

        toggleIcon.addEventListener("click", () => {
            if (passwordInput.type === "password") {
                passwordInput.type = "text";
                toggleIcon.classList.remove("ri-eye-line");
                toggleIcon.classList.add("ri-eye-off-line");
            } else {
                passwordInput.type = "password";
                toggleIcon.classList.remove("ri-eye-off-line");
                toggleIcon.classList.add("ri-eye-line");
            }
        });
    </script>
</x-guest-layout>
