<!DOCTYPE html>
<html lang="en">
<head>
    <meta charset="UTF-8">
        <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <link rel="preconnect" href="https://fonts.googleapis.com">
<link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
<link href="https://fonts.googleapis.com/css2?family=Mukta:wght@200;300;400;500;600;700;800&display=swap" rel="stylesheet">
    
    <title>Referral Report</title>
    <style>
        /* General Styling */
        body {
            font-family: Arial, sans-serif;
            background-color: #f0f0f0;
            display: flex;
            justify-content: center;
            align-items: center;
            min-height: 100vh;
            margin: 0;
        }

        /* Report Container */
        .report-container {
            background: white;
            width: 700px;
            border-radius: 12px;
            box-shadow: 0 4px 10px rgba(0, 0, 0, 0.1);
            overflow: hidden;
            padding: 20px;
        }
/* Certificate Body */
        .certificate-body {
            padding: 15px;
        }
        /* Header */
        .report-header {
            background-color: #4a4a4a;
            color: white;
            padding: 15px;
            text-align: left;
            border-radius: 10px 10px 0 0;
        }

        .report-header h2 {
            font-size: 18px;
            margin: 0;
        }

        /* Patient Info */
        .patient-info {
            padding: 15px;
        }

        .patient-info h3 {
            margin: 0;
            font-size: 18px;
            color: #333;
        }

        .patient-info p {
            margin: 5px 0;
            font-size: 14px;
            color: #555;
        }

        /* Medical Details */
        .medical-details {
            padding: 15px;
            font-size: 14px;
            color: #444;
        }

        .medical-details ul {
            padding-left: 15px;
        }

        .medical-details ul li {
            margin-bottom: 10px;
            font-size: 14px;
            color: #444;
        }

        /* Doctor Info */
        .doctor-info {
            padding: 15px;
            margin-top: 10px;
        }

        .doctor-info h3 {
            margin: 0;
            font-size: 16px;
        }

        .doctor-info p {
            color: #555;
            font-size: 14px;
            margin: 3px 0;
        }

        /* Footer */
        .report-footer {
            display: flex;
            flex-direction: column;
            justify-content:center; 
            // justify-content: space-between;
            align-items: end;
            padding: 15px;
            border-top: 1px solid #ddd;
            margin-top: 10px;
        }
 .date {
            text-align: right;
            color: #555;
            font-size: 14px;
        }
        .signature-label {
            font-size: 14px;
            color: #888;
        }
 .header_img{
              border-top-right-radius: 12px;
              border-top-right-radius: 12px;
            }
        .signature-img {
            width: 80px;
            height: auto;
        }
    </style>
</head>
<body>
    <div class="report-container">
        <!-- Header -->
          <div class="report-header">
          <h2>Refferal Report</h2>
        </div>
          <div class="certificate-body">
           <div class="date">Date of Consult <br /> <strong>{{ \Carbon\Carbon::parse($referral->Date_of_Consult)->format('d M Y') }}</strong></div>
            </div>

        <!-- Patient Info -->
         <div class="patient-info">
            <h3>{{ $patient->firstName }} {{ $patient->lastName }}</h3>
            <p>{{ $patient->dob }}</p>
            <p>{{ $patient->contactNumber }}</p>
            <p>{{ $patient->homeAddress }}</p>
            <p>{{ $patient->healthInsuranceNumber ?? 'N/A' }}</p>
           
            <p><strong>Date:</strong>{{ \Carbon\Carbon::now()->format('d M Y') }}</p>
        </div>

        <!-- Medical Details -->
        <div class="medical-details">
            <ul>
                <li><strong>Indication:</strong> {{  $referral->Indication }}</li>
                <li><strong>Requested Referral:</strong> {{  $referral->Requested_Referral }}</li>
            </ul>
        </div>

        <!-- Doctor Info -->
        <div class="doctor-info">
            <h3>Dr. {{ $doctor->firstName }} {{ $doctor->lastName }}</h3>
            <!-- <strong style="text-align:center">( {{ $doctor->specialist }} )</strong><br> -->
            <p>QuickMed Team</p>
            <p>RCC Number: {{ $doctor->rccNumber }}</p>
            <p>GLN Number: {{ $doctor->glnNumber }}</p>
            <p>Address: {{ $doctor->homeAddress }}</p>
        </div>
        <!-- Footer with Signature -->
         <div class="report-footer">
            <img src="https://quickmed.technoderivation.com/admin/public/app/{{ $doctor->signatureImage }}" 
              alt="Doctor Signature" style="width:120px; height:auto; border:1px solid #ccc;margin-top:10px;">
            
        </div>
    </div>
</body>
</html>
