@if ($paginator->hasPages())
<div class="custom-pagination">
    <div class="pagination-info">
    </div>

    <div class="pagination-controls">
        {{-- Previous Page Link --}}
        @if ($paginator->onFirstPage())
        <span class="disabled">&lsaquo;</span>
        @else
        <a href="{{ $paginator->previousPageUrl() }}" rel="prev">&lsaquo;</a>
        @endif

        {{-- Pagination Elements --}}
        @foreach ($elements as $element)
        {{-- Dots --}}
        @if (is_string($element))
        <span class="dots">{{ $element }}</span>
        @endif

        {{-- Page Number Links --}}
        @if (is_array($element))
        @foreach ($element as $page => $url)
        @if ($page == $paginator->currentPage())
        <span class="active">{{ $page }}</span>
        @else
        <a href="{{ $url }}">{{ $page }}</a>
        @endif
        @endforeach
        @endif
        @endforeach

        {{-- Next Page Link --}}
        @if ($paginator->hasMorePages())
        <a href="{{ $paginator->nextPageUrl() }}" rel="next">&rsaquo;</a>
        @else
        <span class="disabled">&rsaquo;</span>
        @endif
    </div>
</div>
@endif