<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\DoctorAuthController;
use App\Http\Controllers\PatientController;
use Illuminate\Support\Facades\Route;

Route::get('/', function () {
    return redirect()->route('doctor.login');
});

// Doctor Auth Routes
Route::get('doctor/login', [DoctorAuthController::class, 'showLoginForm'])
    ->name('doctor.login'); // keep only this


Route::post('doctor/login', [DoctorAuthController::class, 'login'])->name('doctor.login.submit');
Route::post('doctor/logout', [DoctorAuthController::class, 'logout'])->name('doctor.logout');

// Forgot Password
Route::get('/doctor/forgot-password', [DoctorAuthController::class, 'showForgotPasswordForm'])->name('doctor.forgot.password');
Route::post('/doctor/forgot-password', [DoctorAuthController::class, 'sendOtp'])->name('doctor.forgot.password.submit');

// OTP Page
Route::get('/doctor/verify-otp', [DoctorAuthController::class, 'showOtpForm'])->name('doctor.verify.otp');
Route::post('/doctor/verify-otp', [DoctorAuthController::class, 'verifyOtp'])->name('doctor.verify.otp.submit');

Route::get('reset-password', [DoctorAuthController::class, 'showResetPasswordForm'])->name('doctor.reset.password.form');
Route::post('reset-password', [DoctorAuthController::class, 'resetPassword'])->name('doctor.reset.password.submit');


// Doctor Dashboard (protected)
Route::middleware('auth:doctor')->group(function () {

    Route::get('doctor/dashboard', function () {
        return view('doctor.dashboard');
    })->name('doctor.dashboard');

    Route::get('/index', [PatientController::class, 'index'])->name('admin.index');
    Route::get('/patients/{id}', [PatientController::class, 'detail'])->name('admin.detail');

Route::post('/medical-report/store', [PatientController::class, 'storeMedicalReport'])->name('medicalReport.store');
Route::post('/prescription/store', [PatientController::class, 'storePrescription'])->name('prescription.store');
Route::post('/referral/store', [PatientController::class, 'storeReferral'])->name('referral.store');
Route::post('/sicknote/store', [PatientController::class, 'storeSickNote'])->name('sicknote.store');



    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');
});


use Illuminate\Support\Facades\Artisan;

Route::get('/clear-all', function () {
    Artisan::call('config:clear');
    Artisan::call('cache:clear');
    Artisan::call('route:clear');
    Artisan::call('view:clear');
    Artisan::call('config:cache');
    return '✅ Cache Cleared';
});
