<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Quickmed</title>
    <link href="https://cdn.jsdelivr.net/npm/remixicon@3.5.0/fonts/remixicon.css" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('Assets/style.css')); ?>" />
    <link rel="shortcut icon" href="<?php echo e(asset('Assets/Fav-icon.png')); ?>" type="image/x-icon">


   
</head>

<div class="loading" id="loader" style="display: none;">Loading…</div>

<style>

.loading {
  position: fixed;
  z-index: 9999;
  height: 2em;
  width: 2em;
  overflow: show;
  margin: auto;
  top: 0;
  left: 0;
  bottom: 0;
  right: 0;
}

/* Transparent Overlay */
.loading:before {
  content: '';
  display: block;
  position: fixed;
  top: 0;
  left: 0;
  width: 100%;
  height: 100%;
    background: radial-gradient(rgba(20, 20, 20,.8), rgba(0, 0, 0, .8));

  background: -webkit-radial-gradient(rgba(20, 20, 20,.8), rgba(0, 0, 0,.8));
}

/* :not(:required) hides these rules from IE9 and below */
.loading:not(:required) {
  /* hide "loading..." text */
  font: 0/0 a;
  color: transparent;
  text-shadow: none;
  background-color: transparent;
  border: 0;
}

.loading:not(:required):after {
  content: '';
  display: block;
  font-size: 10px;
  width: 1em;
  height: 1em;
  margin-top: -0.5em;
  -webkit-animation: spinner 150ms infinite linear;
  -moz-animation: spinner 150ms infinite linear;
  -ms-animation: spinner 150ms infinite linear;
  -o-animation: spinner 150ms infinite linear;
  animation: spinner 150ms infinite linear;
  border-radius: 0.5em;
  -webkit-box-shadow: rgba(255,255,255, 0.75) 1.5em 0 0 0, rgba(255,255,255, 0.75) 1.1em 1.1em 0 0, rgba(255,255,255, 0.75) 0 1.5em 0 0, rgba(255,255,255, 0.75) -1.1em 1.1em 0 0, rgba(255,255,255, 0.75) -1.5em 0 0 0, rgba(255,255,255, 0.75) -1.1em -1.1em 0 0, rgba(255,255,255, 0.75) 0 -1.5em 0 0, rgba(255,255,255, 0.75) 1.1em -1.1em 0 0;
box-shadow: rgba(255,255,255, 0.75) 1.5em 0 0 0, rgba(255,255,255, 0.75) 1.1em 1.1em 0 0, rgba(255,255,255, 0.75) 0 1.5em 0 0, rgba(255,255,255, 0.75) -1.1em 1.1em 0 0, rgba(255,255,255, 0.75) -1.5em 0 0 0, rgba(255,255,255, 0.75) -1.1em -1.1em 0 0, rgba(255,255,255, 0.75) 0 -1.5em 0 0, rgba(255,255,255, 0.75) 1.1em -1.1em 0 0;
}

/* Animation */

@-webkit-keyframes spinner {
  0% {
    -webkit-transform: rotate(0deg);
    -moz-transform: rotate(0deg);
    -ms-transform: rotate(0deg);
    -o-transform: rotate(0deg);
    transform: rotate(0deg);
  }
  100% {
    -webkit-transform: rotate(360deg);
    -moz-transform: rotate(360deg);
    -ms-transform: rotate(360deg);
    -o-transform: rotate(360deg);
    transform: rotate(360deg);
  }
}
@-moz-keyframes spinner {
  0% {
    -webkit-transform: rotate(0deg);
    -moz-transform: rotate(0deg);
    -ms-transform: rotate(0deg);
    -o-transform: rotate(0deg);
    transform: rotate(0deg);
  }
  100% {
    -webkit-transform: rotate(360deg);
    -moz-transform: rotate(360deg);
    -ms-transform: rotate(360deg);
    -o-transform: rotate(360deg);
    transform: rotate(360deg);
  }
}
@-o-keyframes spinner {
  0% {
    -webkit-transform: rotate(0deg);
    -moz-transform: rotate(0deg);
    -ms-transform: rotate(0deg);
    -o-transform: rotate(0deg);
    transform: rotate(0deg);
  }
  100% {
    -webkit-transform: rotate(360deg);
    -moz-transform: rotate(360deg);
    -ms-transform: rotate(360deg);
    -o-transform: rotate(360deg);
    transform: rotate(360deg);
  }
}
@keyframes spinner {
  0% {
    -webkit-transform: rotate(0deg);
    -moz-transform: rotate(0deg);
    -ms-transform: rotate(0deg);
    -o-transform: rotate(0deg);
    transform: rotate(0deg);
  }
  100% {
    -webkit-transform: rotate(360deg);
    -moz-transform: rotate(360deg);
    -ms-transform: rotate(360deg);
    -o-transform: rotate(360deg);
    transform: rotate(360deg);
  }
}    
/* Toast container */
#toast {
    position: fixed;
    top: 20px;
    right: 20px;
    min-width: 250px;
    padding: 15px 20px;
    border-radius: 5px;
    color: #fff;
    display: flex;
    align-items: center;
    gap: 10px;
    z-index: 9999;
    box-shadow: 0 4px 6px rgba(0,0,0,0.1);
    font-family: Arial, sans-serif;
}

/* Success and error colors */
.toast-success { background-color: #4CAF50; }
.toast-error { background-color: #f44336; }

/* Close button */
.close-btn {
    background: transparent;
    border: none;
    color: #fff;
    font-weight: bold;
    font-size: 16px;
    cursor: pointer;
    margin-left: auto;
}

/* Optional: fade effect */
#toast {
    animation: fadein 0.5s, fadeout 0.5s 2.5s;
}

@keyframes fadein {
    from {opacity: 0; top: 0;}
    to {opacity: 1; top: 20px;}
}

@keyframes fadeout {
    from {opacity: 1; top: 20px;}
    to {opacity: 0; top: 0;}
}
</style>


<body>

     <?php if(session('error')): ?>
    <div id="toast" class="toast-error">
        <!-- <span class="icon">⚠️</span> -->
        <span><?php echo e(session('error')); ?></span>
        <button class="close-btn" onclick="document.getElementById('toast').style.display='none'"></button>
    </div>
<?php endif; ?>


<?php if(session('success')): ?>
    <div id="toast" class="toast-success">
        <!-- <span class="icon">✅</span> -->
        <span><?php echo e(session('success')); ?></span>
        <button class="close-btn" onclick="document.getElementById('toast').style.display='none'"></button>
    </div>
<?php endif; ?>

  
    <div class="container">

        <aside class="sidebar">
            <div class="logo-section">
                <img src="<?php echo e(asset('Assets/sidebar-logo.png')); ?>" alt="QuickMed Logo">
                <hr>
            </div>
            <nav class="menu">
                <a href="<?php echo e(route('admin.index')); ?>" class="active">
                    <i class="ri-user-line"></i> Patients
                </a>

            </nav>
           <div class="logout">
                <!-- Hidden form -->
                <form id="logout-form" action="<?php echo e(route('doctor.logout')); ?>" method="POST" style="display:none;">
                    <?php echo csrf_field(); ?>
                </form>

                <!-- Logout link opens modal -->
                <a href="#" onclick="event.preventDefault(); openLogoutModal();">
                    <img src="<?php echo e(asset('Assets/logout.svg')); ?>" alt="log-out"> Log Out
                </a>
            </div>

        </aside>

        <div class="right-page">
            <div class="header-row">
                <div class="header-left">
                    <i class="ri-menu-line sidebar-toggle"></i>
                    <h1>Patients</h1>
                </div>

                <div style="display: flex; align-items: center; gap: 10px;">


                    <?php if(!empty($doctor->profilePath)): ?>
                        <img src="https://quickmed.technoderivation.com/admin/public/app/<?php echo e($doctor->profilePath); ?>" 
                             alt="Profile" 
                             class="profile-img"
                             style="width: 40px; height: 40px; border-radius: 50%;">
                    <?php else: ?>
                        <img src="https://quickmed.technoderivation.com/admin/public/uploads/no_image.jpg" 
                             alt="Default Profile" 
                             class="profile-img"
                             style="width: 40px; height: 40px; border-radius: 50%;">
                    <?php endif; ?>





                    <div style="display: flex; flex-direction: column; line-height: 1.2;">
                        <span style="font-weight: bold;"><?php echo e($doctor->firstName); ?> <?php echo e($doctor->lastName); ?></span>
                        <span style="font-size: 12px; color: #999999;">Doctor</span>
                    </div>
                </div>
            </div>

            <hr>
            <div class="tabs-search">
                <!-- <div class="tabs-wrapper">
                    <div class="tabs">
                        <a href="index.html" class="tab active">Allergies</a>
                        <a href="approved.html" class="tab">Medical</a>
                        <a href="rejected.html" class="tab">Medications</a>
                    </div>
                </div> -->

                <!-- <div class="search-box">
                    <input type="text" placeholder="Search">
                    <i class="ri-search-line"></i>
                </div> -->
                                      
            </div>
 
            <div class="header-row">

                <!-- Left Section -->
                <div class="addprescription">
                    <a class="back-btn" href="<?php echo e(route('admin.index')); ?>">
                        <i class="ri-arrow-left-line"></i>
                    </a>
                    <h1>Add Prescription</h1>
                </div>


                <!-- Right Section -->  
<div class="Health">

  <?php if($consultRequest->payment_method == 'Stripe'): ?>
      <button class="btn-custom" id="healthInsuranceBtn" style="display: none;">Health Insurance</button>
  <?php else: ?>
      <button class="btn-custom" id="healthInsuranceBtn">Health Insurance Image</button>

  <?php endif; ?>

 

 <button class="btn-custom" id="appointmentBtn">Appointment Images</button>
</div>


            </div>




<style>
    .modal-overlay {
      position: fixed;
      top: 0;
      left: 0;
      height: 100vh;
      width: 100vw;
      background: rgba(0, 0, 0, 0.7);
      display: flex;
      align-items: center;
      justify-content: center;
      z-index: 1000;
    }


    .modal-content {
      background: #fff;
      border-radius: 12px;
      padding: 0px;
      width: 100%;
      max-width: 600px;
      box-shadow: 0 10px 30px rgba(0, 0, 0, 0.2);
    }

    .modal-header {
        padding: 16px 20px;
        background: #f2f0f0;
      display: flex;
      justify-content: space-between;
      align-items: center;
      margin-bottom: 10px;
    }

    .modal-header h2 {
      margin: 0;
      font-size: 18px;
    }

    .close-btn {
      font-size: 22px;
      background: none;
      border: none;
      cursor: pointer;
      color: #333;
    }

    .modal-body {
      max-height: 400px;
      overflow-y: auto;
    }

   
   .modal-body img {
    width: 100%;
    /* margin: auto; */
   
    padding-bottom: 0px;
    padding: 25px;
}

    .payment_reciept a {
    font-weight: bold;
    text-decoration: none;
    font-size: 16px;
    color: #141414;
}
.payment_reciept {
    font-size: 28px;
    line-height: 0px;
    margin-left: 40px;
    color: #000;
    border: 1px solid #13e0e0;
    padding: 23px 47px;
}
  </style>
<div class="profile-card">
    <div class="profile-header">
      

        <?php if(!empty($patient->profilePath)): ?>
            <img src="https://quickmed.technoderivation.com/admin/public/app/<?php echo e($patient->profilePath); ?>" 
                 alt="Profile" 
                 class="profile-img"
                 style="width: 40px; height: 40px; border-radius: 50%;">
        <?php else: ?>
            <img src="https://quickmed.technoderivation.com/admin/public/uploads/no_image.jpg" 
                 alt="Default Profile" 
                 class="profile-img"
                 style="width: 40px; height: 40px; border-radius: 50%;">
        <?php endif; ?>



        <div>
            <h3 class="name"><?php echo e($patient->firstName); ?> <?php echo e($patient->lastName); ?></h3>
            <p class="location"><span class="icon">📍</span> <?php echo e($patient->country ?? 'N/A'); ?></p>
        </div>
        <?php if(!empty($consultRequest->paymentProofPath)): ?>
            <div class="payment_reciept">
                <i class="ri-bank-line"></i> <a href="https://quickmed.technoderivation.com/admin/public/paymentReceipts/<?php echo e($consultRequest->paymentProofPath); ?>" target="_blank">View Payment Reciept</a>
            </div>
        <?php endif; ?>
    </div>
    <hr>
    
    <h2 style="color: #13e0e0;font-size: 20px;padding-bottom: 22px;">Patient Details</h2>
    <div class="details-grid">

        <div class="detail"><strong>Email</strong><br><span><?php echo e($patient->email ?? 'N/A'); ?></span></div>
        <div class="detail"><strong>Contact No.</strong><br><span><?php echo e($patient->countryCode ?? 'N/A'); ?><?php echo e($patient->contactNumber ?? 'N/A'); ?></span></div>
        <div class="detail"><strong>DOB</strong><br><span><?php echo e($patient->dob ?? 'N/A'); ?></span></div>
        <div class="detail"><strong>Age</strong><br>
           <?php if(!empty($patient->age)): ?> 
            <span><?php echo e($patient->age); ?> Year </span>
            <?php else: ?>
            <span><?php echo e(\Carbon\Carbon::parse($patient->dob)->age); ?> Year</span>
            <?php endif; ?>
        </div>
        <div class="detail"><strong>Gender</strong><br><span><?php echo e($patient->gender ?? 'N/A'); ?></span></div>
        <?php if($consultRequest->payment_method != 'Stripe'): ?>
        <div class="detail"><strong>AVS Number</strong><br><span><?php echo e($patient->avsNumber ?? 'N/A'); ?></span></div>
        <div class="detail"><strong>Insurance Name</strong><br><span><?php echo e($patient->insuranceName ?? 'N/A'); ?></span></div>
        <div class="detail"><strong>Insurance Number</strong><br><span><?php echo e($patient->insuranceNumber ?? 'N/A'); ?></span></div>
        <div class="detail"><strong>Insurance Person Name</strong><br><span><?php echo e($patient->insurancePersonName ?? 'N/A'); ?></span></div>
        <div class="detail"><strong>CADA Number</strong><br><span><?php echo e($patient->cadaNumber ?? 'N/A'); ?></span></div>
        <div class="detail"><strong>Valid Till</strong><br><span><?php echo e($patient->validTill ?? 'N/A'); ?></span></div>
        <div class="detail"><strong>Card Type</strong><br><span><?php echo e($patient->cardType ?? 'N/A'); ?></span></div>
       
       <?php endif; ?>
       
    </div>
    <hr>
    <h2 style="color: #13e0e0;font-size: 20px;padding-bottom: 22px;">Consult Request Details</h2>
    <div class="details-grid-consult">
        <div class="detail">
          <strong>Medical Problem</strong><br>
          <?php if($consultRequest->language == 'English'): ?>
            <p><?php echo e($consultRequest->medicalProblem->enName ?? 'N/A'); ?></p>
          <?php endif; ?>

          <?php if($consultRequest->language == 'Français'): ?>
              <p><?php echo e($consultRequest->medicalProblem->frName ?? 'N/A'); ?></p>
          <?php endif; ?>

          <?php if($consultRequest->language == 'German'): ?>
              <p><?php echo e($consultRequest->medicalProblem->deName ?? 'N/A'); ?></p>
          <?php endif; ?>

          <?php if($consultRequest->language == 'Italiano'): ?>
              <p><?php echo e($consultRequest->medicalProblem->itName ?? 'N/A'); ?></p>
          <?php endif; ?>
        </div>
        <div class="detail"><strong>Describe your problem</strong><br><span><?php echo e($consultRequest->description); ?></span></div>
        <div class="detail"><strong>Location </strong><br><span><?php echo e($consultRequest->location); ?></span></div>
        <div class="detail"><strong>Canton</strong><br><span><?php echo e($consultRequest->canton); ?></span></div>
        <div class="detail"><strong>Date of Consult</strong><br><span><?php echo e(\Carbon\Carbon::parse($consultRequest->createdAt)->format('d M, Y H:i:s')); ?></span></div>
        <div class="detail"><strong>Language</strong><br><span><?php echo e($consultRequest->language); ?></span></div>
    </div>
</div>


<div class="consult-section" >
    <div class="tab-buttons" id="consultButtons">
        <button class="tab-btn active" id="pastConsultBtn">Past Consult</button>
        <button class="tab-btn" id="newConsultBtn">New Consult</button>
    </div>


<div id="pastConsultSection">
    <?php if($allConsults->isEmpty()): ?>
        <div class="no-consults">  
            <img src="<?php echo e(asset('Assets/nodata-Dne61JoO.png')); ?>" alt="No Consults Image" />
            <p>No Consults</p>
        </div>
    <?php else: ?>
        <div class="consult-cards">

            <?php $__currentLoopData = $allConsults; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $consult): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="consult-card <?php echo e($loop->first ? 'recent' : ''); ?>" 
                     data-type="<?php echo e(get_class($consult)); ?>" data-item='<?php echo json_encode($consult, 15, 512) ?>'>

                    <div class="consult-header">
                        <h4 class="consult-title">
                            <?php if($consult instanceof \App\Models\PatientsMedicalReport): ?>  Medical Report
                            <?php elseif($consult instanceof \App\Models\Prescription): ?>  Prescription
                            <?php elseif($consult instanceof \App\Models\PatientsRefferal): ?>  Referral
                            <?php elseif($consult instanceof \App\Models\SickNote): ?>  Sick Note
                            <?php endif; ?>
                        </h4>
                        <span class="consult-date">
                        <?php if($consult instanceof \App\Models\PatientsMedicalReport): ?>
                            <?php echo e(\Carbon\Carbon::parse($consult->Date_of_Consult)->format('d M, Y')); ?>

                        <?php elseif($consult instanceof \App\Models\Prescription): ?>
                            <?php echo e(\Carbon\Carbon::parse($consult->created_at)->format('d M, Y')); ?>

                        <?php elseif($consult instanceof \App\Models\PatientsRefferal): ?>
                            <?php echo e($consult->created_at->format('d M, Y')); ?>

                        <?php elseif($consult instanceof \App\Models\SickNote): ?>
                            <?php echo e(\Carbon\Carbon::parse($consult->Start_Date_of_Absence)->format('d M, Y')); ?>

                        <?php endif; ?>
                    </span>

                    </div>

                    <div class="consult-body">
                        <?php if($consult instanceof \App\Models\PatientsMedicalReport): ?>
                            
                            <?php if($consult->consultRequest->language == 'English'): ?>
                                <p><?php echo e($consult->consultRequest->medicalProblem->enName ?? 'N/A'); ?></p>
                            <?php endif; ?>

                            <?php if($consult->consultRequest->language == 'Français'): ?>
                                <p><?php echo e($consult->consultRequest->medicalProblem->frName ?? 'N/A'); ?></p>
                            <?php endif; ?>

                            <?php if($consult->consultRequest->language == 'German'): ?>
                                <p><?php echo e($consult->consultRequest->medicalProblem->deName ?? 'N/A'); ?></p>
                            <?php endif; ?>

                            <?php if($consult->consultRequest->language == 'Italiano'): ?>
                                <p><?php echo e($consult->consultRequest->medicalProblem->itName ?? 'N/A'); ?></p>
                            <?php endif; ?>

                           

                        <?php elseif($consult instanceof \App\Models\Prescription): ?>

                           <?php if($consult->consultRequest->language == 'English'): ?>
                                <p><?php echo e($consult->consultRequest->medicalProblem->enName ?? 'N/A'); ?></p>
                            <?php endif; ?>

                            <?php if($consult->consultRequest->language == 'Français'): ?>
                                <p><?php echo e($consult->consultRequest->medicalProblem->frName ?? 'N/A'); ?></p>
                            <?php endif; ?>

                            <?php if($consult->consultRequest->language == 'German'): ?>
                                <p><?php echo e($consult->consultRequest->medicalProblem->deName ?? 'N/A'); ?></p>
                            <?php endif; ?>

                            <?php if($consult->consultRequest->language == 'Italiano'): ?>
                                <p><?php echo e($consult->consultRequest->medicalProblem->itName ?? 'N/A'); ?></p>
                            <?php endif; ?>

                        <?php elseif($consult instanceof \App\Models\PatientsRefferal): ?>
                            <?php if($consult->consultRequest->language == 'English'): ?>
                                <p><?php echo e($consult->consultRequest->medicalProblem->enName ?? 'N/A'); ?></p>
                            <?php endif; ?>

                            <?php if($consult->consultRequest->language == 'Français'): ?>
                                <p><?php echo e($consult->consultRequest->medicalProblem->frName ?? 'N/A'); ?></p>
                            <?php endif; ?>

                            <?php if($consult->consultRequest->language == 'German'): ?>
                                <p><?php echo e($consult->consultRequest->medicalProblem->deName ?? 'N/A'); ?></p>
                            <?php endif; ?>

                            <?php if($consult->consultRequest->language == 'Italiano'): ?>
                                <p><?php echo e($consult->consultRequest->medicalProblem->itName ?? 'N/A'); ?></p>
                            <?php endif; ?>
                        <?php elseif($consult instanceof \App\Models\SickNote): ?>
                           
                           <?php if($consult->consultRequest->language == 'English'): ?>
                                <p><?php echo e($consult->consultRequest->medicalProblem->enName ?? 'N/A'); ?></p>
                            <?php endif; ?>

                            <?php if($consult->consultRequest->language == 'Français'): ?>
                                <p><?php echo e($consult->consultRequest->medicalProblem->frName ?? 'N/A'); ?></p>
                            <?php endif; ?>

                            <?php if($consult->consultRequest->language == 'German'): ?>
                                <p><?php echo e($consult->consultRequest->medicalProblem->deName ?? 'N/A'); ?></p>
                            <?php endif; ?>

                            <?php if($consult->consultRequest->language == 'Italiano'): ?>
                                <p><?php echo e($consult->consultRequest->medicalProblem->itName ?? 'N/A'); ?></p>
                            <?php endif; ?>

                        <?php endif; ?>
                    </div>
                    <span class="consult-arrow">➔</span>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                
        </div>
    <?php endif; ?>
</div>

<div id="newConsultSection" style="display:none;">
        <div class="header-bar">
            <span class="back-arrow" id="backToConsults"><i class="ri-arrow-left-s-line"></i></span>
            <span class="header-title">New Consult</span>
        </div>

        <!-- Tabs -->
        <div class="tabs-search" style="padding-top: 24px;">
            <div class="tabs-wrapper" style="width: 100%;">
                <div class="tabs">
                    <button class="tab active" data-target="reportSection">Medical Report </button>
                    <button class="tab" data-target="prescriptionSection">Prescription</button>
                    <button class="tab" data-target="referralSection">Referral</button>
                    <button class="tab" data-target="sicknoteSection">Sick Note</button>
                </div>
            </div>
        </div>

<div id="reportSection" class="consult-form">
    <form id="medicalReportForm" method="POST" action="<?php echo e(route('medicalReport.store')); ?>">
        <?php echo csrf_field(); ?>

                    <div class="form-row">
                        <div class="form-group">
                            <label for="consult_date">Date of Consult</label>
                            <input type="date" id="consult_date" name="Date_of_Consult" class="input-box" />
                        </div>
                        
                        <input type="hidden" name="patient_id" value="<?php echo e($patient->id); ?>">
                        <input type="hidden" name="consult_id" value="<?php echo e($consultRequest->id); ?>">
                        
                       
                    </div>
                        <div class="form-row">
                            <div class="form-group">
                                <label for="diagnosis">Diagnosis</label>
                                <textarea id="diagnosis" name="Diagnosis" class="input-box" rows="4"></textarea>
                                <?php $__errorArgs = ['Diagnosis'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
        <span class="error-message" style="text-align: left;color: red;font-size: 14px;padding: 5px 4px;font-style: italic;"><?php echo e($message); ?></span>
    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="form-group">
                                <label for="anamnesis">Current Anamnesis</label>
                                <textarea id="anamnesis" name="Current_anamnesis" class="input-box" rows="4"></textarea>
                                 <?php $__errorArgs = ['Current_anamnesis'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
        <span class="error-message" style="text-align: left;color: red;font-size: 14px;padding: 5px 4px;font-style: italic;"><?php echo e($message); ?></span>
    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group">
                                <label for="treatment">Treatment</label>
                                <textarea id="treatment" name="Treatment" class="input-box" rows="4"></textarea>
                                 <?php $__errorArgs = ['Treatment'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
        <span class="error-message" style="text-align: left;color: red;font-size: 14px;padding: 5px 4px;font-style: italic;"><?php echo e($message); ?></span>
    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="form-group">
                                <label for="plan">Plan</label>
                                <textarea id="plan" name="Plan" class="input-box" rows="4"></textarea>
                                <?php $__errorArgs = ['Plan'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
        <span class="error-message" style="text-align: left;color: red;font-size: 14px;padding: 5px 4px;font-style: italic;"><?php echo e($message); ?></span>
    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group">
                                <label for="comorbidities">Comorbidities</label>

                                <?php if(!empty($medicalReportSingle->Comorbidities)): ?>
                                   <textarea id="comorbidities" name="Comorbidities" class="input-box" rows="4"><?php echo e($medicalReportSingle->Comorbidities); ?></textarea> 
                                <?php else: ?>
                                  <textarea id="comorbidities" name="Comorbidities" class="input-box" rows="4"></textarea>  
                                <?php endif; ?>

                               <?php $__errorArgs = ['Comorbidities'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="error-message" style="text-align: left;color: red;font-size: 14px;padding: 5px 4px;font-style: italic;"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="form-group">
                                <label for="usual_treatment">Usual Treatment</label>
                                
                                <?php if(!empty($medicalReportSingle->Usual_Treatment)): ?>
                                   <textarea id="usual_treatment" name="Usual_Treatment" class="input-box" rows="4"><?php echo e($medicalReportSingle->Usual_Treatment); ?></textarea> 
                                <?php else: ?>
                                  <textarea id="usual_treatment" name="Usual_Treatment" class="input-box" rows="4"></textarea>  
                                <?php endif; ?>

                               


                                  <?php $__errorArgs = ['Usual_Treatment'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                <span class="error-message" style="text-align: left;color: red;font-size: 14px;padding: 5px 4px;font-style: italic;"><?php echo e($message); ?></span>
                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="form-row">
                            <div class="form-group">
                                <label for="allergies">Allergies  </label>

                                 <?php if(!empty($medicalReportSingle->Allergies)): ?>
                                   <textarea id="allergies" name="Allergies" class="input-box" rows="4"><?php echo e($medicalReportSingle->Allergies); ?></textarea> 
                                <?php else: ?>
                                  <textarea id="allergies" name="Allergies" class="input-box" rows="4"></textarea>  
                                <?php endif; ?>

                                
                                 <?php $__errorArgs = ['Allergies'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
        <span class="error-message" style="text-align: left;color: red;font-size: 14px;padding: 5px 4px;font-style: italic;"><?php echo e($message); ?></span>
    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <div id="hiddenEmails"></div>

                        <div class="Health">
                            <button type="button" class="btn-custom" onclick="previewMedicalReport()">Preview</button>
                        </div>
                    </form>
                </div>

                <!-- PRESCRIPTION -->
                <div id="prescriptionSection" class="consult-form" style="display:none;">
                   <form id="prescriptionForm" method="POST" action="<?php echo e(route('prescription.store')); ?>">
    <?php echo csrf_field(); ?>
                        <div class="form-row">
                            <div class="form-group">
                                <label for="prescription_medication">Prescription</label>
                                <textarea id="prescription_medication" name="Diagnosis" class="input-box" rows="4"></textarea>
                                 <?php $__errorArgs = ['Diagnosis'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
        <span class="error-message" style="text-align: left;color: red;font-size: 14px;padding: 5px 4px;font-style: italic;"><?php echo e($message); ?></span>
    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <input type="hidden" name="patient_id" value="<?php echo e($patient->id); ?>">
<input type="hidden" name="consult_id" value="<?php echo e($consultRequest->id); ?>">
                             <!-- <div class="form-group">
                                <label for="prescription_time">Time</label>
                                <select id="prescription_time" name="Time" class="input-box-time">
                                    <option></option>
<option value="00:05:00">5 Minutes</option>
<option value="00:10:00">10 Minutes</option>
<option value="00:15:00">15 Minutes</option>
<option value="00:20:00">20 Minutes</option>

                                </select>
                                <?php $__errorArgs = ['Time'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
        <span class="error-message" style="text-align: left;color: red;font-size: 14px;padding: 5px 4px;font-style: italic;"><?php echo e($message); ?></span>
    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div> -->
                        </div>
                        <div id="hiddenEmails"></div>
                        <div class="Health">
                            <button type="button" class="btn-custom" onclick="previewPrescription()">Preview</button>
                        </div>
                    </form>
                </div>

                <!-- REFERRAL -->
                <div id="referralSection" class="consult-form" style="display:none;">
                    <form id="referralForm" method="POST" action="<?php echo e(route('referral.store')); ?>">
    <?php echo csrf_field(); ?>

     <div class="form-row">

     <!-- <div class="form-group">
                                <label for="consult_timer">Time</label>
                                <select id="consult_timer" name="Time" class="input-box-time">
                                    <option></option>
<option value="00:05:00">5 Minutes</option>
<option value="00:10:00">10 Minutes</option>
<option value="00:15:00">15 Minutes</option>
<option value="00:20:00">20 Minutes</option>

                                </select>

                                  <?php $__errorArgs = ['Time'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
        <span class="error-message" style="text-align: left;color: red;font-size: 14px;padding: 5px 4px;font-style: italic;"><?php echo e($message); ?></span>
    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div> -->
                            <input type="hidden" name="patient_id" value="<?php echo e($patient->id); ?>">
<input type="hidden" name="consult_id" value="<?php echo e($consultRequest->id); ?>">
                            <!-- <div class="form-group">
                                <label for="reasonr">Reason for Absence</label>
                                <select id="reasonr" name="referral" class="input-box-time">
                                    <option></option>
                                    <option>Work</option>
                                    <option>School</option>
                                    <option>University</option>
                                    <option>Gym</option>
                                </select>

                                  <?php $__errorArgs = ['referral'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
        <span class="error-message" style="text-align: left;color: red;font-size: 14px;padding: 5px 4px;font-style: italic;"><?php echo e($message); ?></span>
    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div> -->

                </div>
                        <div class="form-row">
                            <div class="form-group">
                                <label for="indicationr">Indication</label>
                                <textarea id="indicationr" name="Indication" class="input-box" rows="4"></textarea>
                                                                  <?php $__errorArgs = ['Indication'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
        <span class="error-message" style="text-align: left;color: red;font-size: 14px;padding: 5px 4px;font-style: italic;"><?php echo e($message); ?></span>
    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="form-group">
                                <label for="requested_referralr">Requested Referral</label>
                                <textarea id="requested_referralr" name="Requested_Referral" class="input-box" rows="4"></textarea>
                                                <?php $__errorArgs = ['Requested_Referral'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                        <span class="error-message" style="text-align: left;color: red;font-size: 14px;padding: 5px 4px;font-style: italic;"><?php echo e($message); ?></span>
                    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                                                                        <div id="hiddenEmails"></div>
                        <div class="Health">
                            <button type="button" class="btn-custom" onclick="previewReferral()">Preview</button>
                        </div>
                    </form>
                </div>

                <!-- SICK NOTE -->
                <div id="sicknoteSection" class="consult-form" style="display:none;">
                     <form id="SickNoteForm" method="POST" action="<?php echo e(route('sicknote.store')); ?>">
    <?php echo csrf_field(); ?>
                        <div class="form-row">
                            <div class="form-group">
                                <label for="Reason_for_Absences">Reason for Absence</label>
                                <select id="Reason_for_Absences" name="Reason_for_Absence" class="input-box-time">
                                    <option></option>
                                    <option>Work</option>
                                    <option>School</option>
                                    <option>University</option>
                                    <option>Gym</option>
                                </select>

                                 <?php $__errorArgs = ['Reason_for_Absence'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
        <span class="error-message" style="text-align: left;color: red;font-size: 14px;padding: 5px 4px;font-style: italic;"><?php echo e($message); ?></span>
    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <input type="hidden" name="patient_id" value="<?php echo e($patient->id); ?>">
<input type="hidden" name="consult_id" value="<?php echo e($consultRequest->id); ?>">
                            <div class="form-group">
                                <label for="Start_Date_of_Absences">Start Date of Absence</label>
                                <input type="date" id="Start_Date_of_Absences" name="Start_Date_of_Absence" class="input-box" />
                                                                 <?php $__errorArgs = ['Start_Date_of_Absence'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
        <span class="error-message" style="text-align: left;color: red;font-size: 14px;padding: 5px 4px;font-style: italic;"><?php echo e($message); ?></span>
    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
</div>
                             <div class="form-row">
                            <div class="form-group">
                                <label for="End_Date_of_Absences">End Date of Absence</label>
                                <input type="date" id="End_Date_of_Absences" name="End_Date_of_Absence" class="input-box" />
                                                                                                 <?php $__errorArgs = ['End_Date_of_Absence'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
        <span class="error-message" style="text-align: left;color: red;font-size: 14px;padding: 5px 4px;font-style: italic;"><?php echo e($message); ?></span>
    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
</div>
                            <div class="form-row">
                            <div class="form-group">
                                <label for="Return_Dates">Return Date</label>
                                <input type="date" id="Return_Dates" name="Return_Date" class="input-box" />
                                 <?php $__errorArgs = ['Return_Date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
        <span class="error-message" style="text-align: left;color: red;font-size: 14px;padding: 5px 4px;font-style: italic;"><?php echo e($message); ?></span>
    <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <div class="form-group">
                                <label for="Times">Time</label>
                                <select id="Times" name="Time" class="input-box-time">
                                      <option value="">--Select Time--</option>
                                      <option value="00:05:00">5 Minutes</option>
                                      <option value="00:10:00">10 Minutes</option>
                                      <option value="00:15:00">15 Minutes</option>
                                      <option value="00:20:00">20 Minutes</option> 


                                </select>
                                 <?php $__errorArgs = ['Time'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <span class="error-message" style="text-align: left;color: red;font-size: 14px;padding: 5px 4px;font-style: italic;"><?php echo e($message); ?></span>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                                                                                                <div id="hiddenEmails"></div>
                        <div class="Health">
                            <button type="button" class="btn-custom" onclick="previewSickNote()">Preview</button>
                        </div>
                    </form>
                </div>

               

<script>
    const pastBtn = document.getElementById("pastConsultBtn");
    const newBtn = document.getElementById("newConsultBtn");
    const pastSection = document.getElementById("pastConsultSection");
    const newSection = document.getElementById("newConsultSection");
    const consultButtons = document.getElementById("consultButtons");
    const backArrow = document.getElementById("backToConsults");

    
newBtn.addEventListener("click", () => {
    // document.getElementById("previewModal").style.display = "flex";
    pastSection.style.display = "none";
    consultButtons.style.display = "none";
    newSection.style.display = "block";


    newSection.style.marginTop = "0"; 
});


    
    backArrow.addEventListener("click", () => {
        newSection.style.display = "none";
        consultButtons.style.display = "flex"; 
        pastSection.style.display = "block";
    });

   
    const tabs = document.querySelectorAll(".tabs .tab");
    const sections = ["reportSection", "prescriptionSection", "referralSection", "sicknoteSection"];

    tabs.forEach(tab => {
        tab.addEventListener("click", () => {
            
            tabs.forEach(t => t.classList.remove("active"));
            sections.forEach(id => document.getElementById(id).style.display = "none");

            
            tab.classList.add("active");
            document.getElementById(tab.dataset.target).style.display = "block";
        });
    });

    
</script>




        


    </div>

    </div>

    <div class="overlay"></div>



    <script>
        const toggleBtn = document.querySelector('.sidebar-toggle');
        const sidebar = document.querySelector('.sidebar');
        const overlay = document.querySelector('.overlay');

        toggleBtn.addEventListener('click', () => {
            sidebar.classList.toggle('open');
            overlay.style.display = sidebar.classList.contains('open') ? 'block' : 'none';
        });

        overlay.addEventListener('click', () => {
            sidebar.classList.remove('open');
            overlay.style.display = 'none';
        });
       


    </script>

<div class="modal-overlay" id="previewModal" style="display:none;">
  <div class="modal-content">
    <div class="modal-header">
      <h2>Consult Report</h2>
      <button class="close-btn" onclick="document.getElementById('previewModal').style.display='none'"></button>
    </div>
    <div class="modal-body" id="previewBody"></div>
    
    <div class="modal-footer">
      <button class="btn-custom" id="sendBtn">Send</button>
    </div>
  </div>
</div>






<div class="modal-overlay" id="logoutModal" style="display: none;">
  <div class="modal">
    <div class="modal-icon">
      <img src="<?php echo e(asset('Assets/logout-image.png')); ?>" alt="Logout Icon" style="width: 150px; height: 150px;">
    </div>

    <h2>Are you Leaving?</h2>
    <p>Are you sure you want to Log Out?</p>
    <div class="modal-buttons">
      <button class="btn-no" id="cancelLogout">No</button>
      <form id="logout-form" action="<?php echo e(route('doctor.logout')); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <button type="submit" class="btn-yes">Yes</button>
      </form>
    </div>
  </div>
</div> 


           <!-- Appointment Images Modal -->
<div class="modal-overlay" id="imageModal" style="display: none;">
  <div class="modal-content">
    <div class="modal-header">
      <h2>Appointment Images</h2>
      <button class="close-btn" onclick="closeImageModal()"></button>
    </div>
    <div class="modal-body">
    <?php
        $images = json_decode($consultRequest->image, true);

        if (!$images) {
            // अगर JSON नहीं है तो comma-separated string check करें
            $images = strpos($consultRequest->image, ',') !== false 
                ? explode(',', $consultRequest->image) 
                : [$consultRequest->image];
        }

        // Trim करें और खाली values हटा दें
        $images = array_filter(array_map('trim', $images));
    ?>

    <?php if(!empty($images)): ?>
        <?php $__currentLoopData = $images; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $img): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <img src="<?php echo e('https://quickmed.technoderivation.com/admin/public/app/' . $img); ?>" 
                 alt="Consult Image" style="max-width: 100%; margin-bottom: 20px;">
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    <?php else: ?>
        <p style="text-align: center;color: red;font-weight: 500;padding: 80px 0px;font-size: 18px;">No appointment image</p>
    <?php endif; ?>
</div>

  </div>
</div>


<!-- Health Insurance Modal -->
<div class="modal-overlay" id="healthModal" style="display: none;">
  <div class="modal-content">
    <div class="modal-header">
      <h2>Switch Health Insurance Front & Back Image </h2>
      <button class="close-btn" onclick="closeHealthModal()"></button>
    </div>
    <div class="modal-body">
        <?php if(!empty($patient->cardFrontImage)): ?>
            <img src="https://quickmed.technoderivation.com/admin/public/scanner/<?php echo e($patient->cardFrontImage); ?>" 
                 alt="Profile" 
                 >
        <?php else: ?>
            <img src="https://quickmed.technoderivation.com/admin/public/uploads/no_image.jpg" 
                 alt="Default Profile" 
                 >
        <?php endif; ?>

        <?php if(!empty($patient->cardBackImage)): ?>
            <img src="https://quickmed.technoderivation.com/admin/public/scanner/<?php echo e($patient->cardBackImage); ?>" 
                 alt="Profile" 
                 >
        <?php else: ?>
            <img src="https://quickmed.technoderivation.com/admin/public/uploads/no_image.jpg" 
                 alt="Default Profile" 
                 >
        <?php endif; ?>

      <!-- <img src="<?php echo e(asset('Assets/healt_issues_img.jpg')); ?>" alt="Health Insurance"> -->
    </div>
  </div>
</div>


<!-- Share Prescription Modal -->
<div class="modal-overlay" id="shareModal" style="display:none;">
    <div class="modal-content share-modal-content">
        <div class="modal-header">
            <h2>Share Document</h2>
            <button class="close-btn" onclick="document.getElementById('shareModal').style.display='none'"></button>
        </div>

        <div class="modal-body">
            <div class="emar">
                <label for="shareEmail" class="addmail">Email</label>
                <button type="button" class="add-email">+</button>
            </div>
            <div id="emailContainer">
                <div class="email-row">
                    <input type="email" name="email[]" class="input-box" value="<?php echo e($patient->email ?? ''); ?>" placeholder="Enter email">
                </div>
            </div>
        </div>

        <div class="modal-footer">
            <button class="btn-custom" id="cancelShare">Cancel</button>
            <button class="btn-custom" id="confirmShare" onclick="load()">Share</button>
        </div>
    </div>
</div>


<script>

    
  function openLogoutModal() {
    document.getElementById("logoutModal").style.display = "flex";
  }

  document.getElementById("cancelLogout").addEventListener("click", function () {
    document.getElementById("logoutModal").style.display = "none";
  });

document.addEventListener("DOMContentLoaded", () => {
  const emailContainer = document.getElementById("emailContainer");
  const addEmailBtn = document.querySelector(".add-email");

  // Add new email row
  addEmailBtn.addEventListener("click", function () {
    const newRow = document.createElement("div");
newRow.className = "email-row";
newRow.innerHTML = `
  <input type="email" name="email[]" class="input-box" placeholder="Enter email">
  <span class="js-error"></span>
  <button type="button" class="remove-email">🗑</button>
`;
requestAnimationFrame(() => emailContainer.appendChild(newRow));

  });

  // Remove email row (event delegation)
  emailContainer.addEventListener("click", function (e) {
    if (e.target.classList.contains("remove-email")) {
      e.target.parentElement.remove();
    }
  });
});


</script>



<script>

   


function validateField(fieldId, errorMessage) {
    let field = document.getElementById(fieldId);
    let errorSpan = field.parentElement.querySelector(".js-error");

    if (!field.value.trim()) {
        if (!errorSpan) {
            errorSpan = document.createElement("span");
            errorSpan.classList.add("js-error");
            errorSpan.style.color = "red";
            errorSpan.style.fontSize = "14px";
            errorSpan.style.textAlign = "left";
            errorSpan.style.padding = "5px 4px";
            errorSpan.style.fontStyle = "italic";
            

            field.parentElement.appendChild(errorSpan);
        }
        errorSpan.innerText = errorMessage;
        field.style.border = "2px solid red";
        return false;
    } else {
        if (errorSpan) errorSpan.remove();
        field.style.border = "";
        return true;
    }
}

    
    function sendMedicalReport() {
        let formData = new FormData(document.getElementById("medicalReportForm"));

    fetch("<?php echo e(route('medicalReport.store')); ?>", {
        method: "POST",
        headers: {
            "X-CSRF-TOKEN": "<?php echo e(csrf_token()); ?>"
        },
        body: formData
    }).then(res => res.json())
    .then(data => {
        // alert(data.message);
        document.getElementById("previewModal").style.display = "none";
    });
}


function showPreview(html, formId) {
    document.getElementById("previewBody").innerHTML = html;
    document.getElementById("previewModal").style.display = "flex";

    let sendBtn = document.getElementById("sendBtn");
    sendBtn.style.display = "inline-block";

    sendBtn.onclick = function () {
        document.getElementById("previewModal").style.display = "none";
        document.getElementById("shareModal").style.display = "flex";

        // Confirm share
       document.getElementById("confirmShare").onclick = function () {
    const emailInputs = document.querySelectorAll("#emailContainer input[name='email[]']");
    const emails = [];

    let allValid = true;
    const emailRegex = /^[^\s@]+@[^\s@]+\.[^\s@]+$/;

    emailInputs.forEach(input => {
        const email = input.value.trim();
        // Remove old error if any
        input.style.border = "";
        let errorSpan = input.parentElement.querySelector(".email-error");
        if (errorSpan) errorSpan.remove();

        if (email === "" || !emailRegex.test(email)) {
            allValid = false;
            input.style.border = "2px solid red";

            errorSpan = document.createElement("span");
            errorSpan.classList.add("email-error");
            errorSpan.style.color = "red";
            errorSpan.style.fontSize = "13px";
            errorSpan.style.display = "block";
            errorSpan.innerText = "Enter a valid email";
             input.insertAdjacentElement("afterend", errorSpan);

        } else {
            emails.push(email);
        }
    });

    if (!allValid) {
        return; // stop submit
    }

    // ✅ Clear previously appended hidden inputs
    const form = document.getElementById(formId);
    form.querySelectorAll("input[type='hidden'][name='email[]']").forEach(el => el.remove());

    // Append new hidden inputs
    emails.forEach(email => {
        const hidden = document.createElement("input");
        hidden.type = "hidden";
        hidden.name = "email[]";
        hidden.value = email;
        form.appendChild(hidden);
    });

    form.submit();
};


        // Cancel share
        document.getElementById("cancelShare").onclick = function () {
            document.getElementById("shareModal").style.display = "none";
        };
    };
}


// helper to show error below field
function clearErrors(formId) {
    const form = document.getElementById(formId);
    // Remove previous error spans
    form.querySelectorAll(".js-error").forEach(span => span.remove());
    // Remove red borders
    form.querySelectorAll(".error-border").forEach(el => el.classList.remove("error-border"));
}

function showFieldError(inputEl, message) {
    // Remove old error if exists
    const existing = inputEl.parentElement.querySelector(".js-error");
    if (existing) existing.remove();

    let errorSpan = document.createElement("span");
    errorSpan.classList.add("js-error");
    errorSpan.style.color = "red";
    errorSpan.style.fontSize = "14px";
    errorSpan.style.textAlign = "left";
    errorSpan.style.padding = "5px 4px";
    errorSpan.style.fontStyle = "italic";
    errorSpan.innerText = message;
    inputEl.classList.add("error-border"); // red border
    inputEl.parentElement.appendChild(errorSpan);
}

function validateFields(fields, formId) {
  let allValid = true;
  const form = document.getElementById(formId);

  fields.forEach(f => {
    const input = document.getElementById(f.id);
    const errorEl = input.parentElement.querySelector(".js-error") || document.createElement("span");
    errorEl.className = "js-error";
    errorEl.style = "color:red;font-size:13px;display:block;margin-top:4px;font-style:italic;text-align:left";

    if (!input.value.trim()) {
      errorEl.innerText = f.msg;
      if (!errorEl.parentElement) input.parentElement.appendChild(errorEl);
      input.classList.add("error-border");
      allValid = false;
    } else {
      if (errorEl.parentElement) errorEl.remove();
      input.classList.remove("error-border");
    }
  });

  return allValid;
}

function previewMedicalReport() {
    const fields = [
        { id: "diagnosis", msg: "Diagnosis is required" },
        { id: "anamnesis", msg: "Anamnesis is required" },
        { id: "treatment", msg: "Treatment is required" },
        { id: "plan", msg: "Plan is required" },
        { id: "comorbidities", msg: "Comorbidities are required" },
        { id: "usual_treatment", msg: "Usual Treatment is required" },
        { id: "allergies", msg: "Allergies are required" },
        { id: "consult_date", msg: "date is required" },
       
    ];

    if (!validateFields(fields, "medicalReportForm")) return;

    const f = document.getElementById("medicalReportForm");


    const html = `
         <div class="modal-body">
              <div class="report-card" role="document" aria-label="Medical Report Card">

                <div class="report-head">
                  <div class="report-icon" aria-hidden="true">💊</div>
                  <div class="report-title">MEDICAL REPORT</div>
                  <div style="flex:1"></div> 
                </div>

                <div class="report-content">
                  <div class="patient-meta">
                    <div class="left-meta">
                      <div class="patient-name"><?php echo e($patient->firstName); ?> <?php echo e($patient->lastName); ?></div>
                      <div class="patient-sub"><?php echo e($patient->dob ? \Carbon\Carbon::parse($patient->dob)->format('d F, Y') : 'N/A'); ?></div>
                      <div class="patient-sub"><?php echo e($patient->contactNumber ?? 'N/A'); ?></div>
                      <div class="patient-sub"><?php echo e($patient->homeAddress  ?? 'N/A'); ?></div>
                      <div class="patient-sub"><?php echo e($patient->healthInsuranceNumber  ?? 'N/A'); ?></div>

                    </div>
                    <div class="date-text">
                      Date of Consult - ${
                        f.Date_of_Consult.value
                          ? new Date(f.Date_of_Consult.value)
                              .toLocaleDateString("en-GB", { day: "2-digit", month: "2-digit", year: "numeric" })
                          : "N/A"
                      }
                    </div>
                  </div>

                  <ul class="report-list" aria-label="Report items">
                    <li>
                      <div class="bullet" aria-hidden="true"></div>
                      <div><span class="list-title">Diagnosis</span><span class="list-text"> - ${f.Diagnosis.value}</span></div>
                    </li>

                    <li>
                      <div class="bullet" aria-hidden="true"></div>
                      <div><span class="list-title">Current anamnesis</span><span class="list-text"> - ${f.Current_anamnesis.value}</span></div>
                    </li>

                    <li>
                      <div class="bullet" aria-hidden="true"></div>
                      <div><span class="list-title">Treatment</span><span class="list-text"> - ${f.Treatment.value}</span></div>
                    </li>

                    <li>
                      <div class="bullet" aria-hidden="true"></div>
                      <div><span class="list-title">Plan</span><span class="list-text"> - ${f.Plan.value}</span></div>
                    </li>

                    <li>
                      <div class="bullet" aria-hidden="true"></div>
                      <div><span class="list-title">Comorbidities</span><span class="list-text"> - ${f.Comorbidities.value}</span></div>
                    </li>

                    <li>
                      <div class="bullet" aria-hidden="true"></div>
                      <div><span class="list-title">Usual Treatment</span><span class="list-text"> - ${f.Usual_Treatment.value}</span></div>
                    </li>

                    <li>
                      <div class="bullet" aria-hidden="true"></div>
                      <div><span class="list-title">Allergies</span><span class="list-text"> - ${f.Allergies.value}</span></div>
                    </li>
                  </ul>

                  <div class="doctor-meta">
                    <div class="left-meta">
                      <div class="patient-name">Dr. <?php echo e($doctor->firstName); ?> <?php echo e($doctor->lastName); ?></div>
                      <div class="patient-spe">(<?php echo e($doctor->specialist); ?>)</div>
                      <div class="patient-sub">QuickMed Team</div>
                      <div class="patient-sub">RCC number: (<?php echo e($doctor->rccNumber); ?>)</div>
                      <div class="patient-sub">GLN number: (<?php echo e($doctor->glnNumber); ?>)</div>
                      <div class="patient-sub"><?php echo e($doctor->homeAddress); ?></div>
                      
                      <div class="doc_signature">
                        <img src="<?php echo e('https://quickmed.technoderivation.com/admin/public/app/' . $doctor->signatureImage); ?>">
                       
                      </div>
                    </div>
                    
                  </div>

                  <div class="report-footer"></div>
                </div>

              </div>
            </div>`;
    
    showPreview(html, "medicalReportForm");
}


function previewPrescription() {
    const fields = [
        { id: "prescription_medication", msg: "Prescription is required" },
        // { id: "prescription_time", msg: "Time is required" }
    ];

    if (!validateFields(fields, "prescriptionForm")) return;

    const f = document.getElementById("prescriptionForm");

    const html = `
    <div class="modal-body">
      <div class="report-card" role="document" aria-label="Prescription Report">

        <div class="report-head">
          <div class="report-icon" aria-hidden="true">💊</div>
          <div class="report-title">PRESCRIPTION</div>
          <div style="flex:1"></div>
        </div>

        <div class="report-content">
          <div class="patient-meta">
            <div class="left-meta">
              <div class="patient-name"><?php echo e($patient->firstName); ?> <?php echo e($patient->lastName); ?></div>
              <div class="patient-sub"><?php echo e($patient->dob ? \Carbon\Carbon::parse($patient->dob)->format('d F, Y') : 'N/A'); ?></div>
              <div class="patient-sub"><?php echo e($patient->contactNumber ?? 'N/A'); ?></div>
              <div class="patient-sub"><?php echo e($patient->homeAddress  ?? 'N/A'); ?></div>
              <div class="patient-sub"><?php echo e($patient->healthInsuranceNumber  ?? 'N/A'); ?></div>

            </div>
          </div>

          <ul class="report-list" aria-label="Prescription items">
            <li>
              <div class="bullet"></div>
              <div><span class="list-title">Medication</span><span class="list-text"> - ${f.prescription_medication.value}</span></div>
            </li>
        
          </ul>

          <div class="doctor-meta">
             <div class="left-meta">
              <div class="patient-name">Dr. <?php echo e($doctor->firstName); ?> <?php echo e($doctor->lastName); ?></div>
              <div class="patient-spe">(<?php echo e($doctor->specialist); ?>)</div>
              <div class="patient-sub">QuickMed Team</div>
              <div class="patient-sub">RCC number: (<?php echo e($doctor->rccNumber); ?>)</div>
              <div class="patient-sub">GLN number: (<?php echo e($doctor->glnNumber); ?>)</div>
              <div class="patient-sub"><?php echo e($doctor->homeAddress); ?></div>
              
              <div class="doc_signature">
                <img src="<?php echo e('https://quickmed.technoderivation.com/admin/public/app/' . $doctor->signatureImage); ?>">
                
              </div>
            </div>
            
          </div>

        </div>
      </div>
    </div>`;

    showPreview(html, "prescriptionForm");
}


function previewReferral() {
    const fields = [
        // { id: "consult_timer", msg: "Time is required" },
        // { id: "reasonr", msg: "Reason is required" },
        { id: "indicationr", msg: "Indication is required" },
        { id: "requested_referralr", msg: "Requested referral is required" }
    ];

    if (!validateFields(fields, "referralForm")) return;

    const f = document.getElementById("referralForm");

    const html = `
    <div class="modal-body">
      <div class="report-card" role="document" aria-label="Referral Report">

        <div class="report-head">
          <div class="report-icon" aria-hidden="true">📑</div>
          <div class="report-title">REFERRAL</div>
          <div style="flex:1"></div>
        </div>

        <div class="report-content">
          <div class="patient-meta">
            <div class="left-meta">
              <div class="patient-name"><?php echo e($patient->firstName); ?> <?php echo e($patient->lastName); ?></div>
              <div class="patient-sub"><?php echo e($patient->dob ? \Carbon\Carbon::parse($patient->dob)->format('d F, Y') : 'N/A'); ?></div>
              <div class="patient-sub"><?php echo e($patient->contactNumber ?? 'N/A'); ?></div>
              <div class="patient-sub"><?php echo e($patient->homeAddress  ?? 'N/A'); ?></div>
              <div class="patient-sub"><?php echo e($patient->healthInsuranceNumber  ?? 'N/A'); ?></div>

            </div>
          </div>

          <ul class="report-list">
            
            
            <li><div class="bullet"></div><div><span class="list-title">Indication</span><span class="list-text"> - ${f.indicationr.value}</span></div></li>
            <li><div class="bullet"></div><div><span class="list-title">Requested Referral</span><span class="list-text"> - ${f.requested_referralr.value}</span></div></li>
          </ul>

          <div class="doctor-meta">
            <div class="left-meta">
              <div class="patient-name">Dr. <?php echo e($doctor->firstName); ?> <?php echo e($doctor->lastName); ?></div>
              <div class="patient-spe">(<?php echo e($doctor->specialist); ?>)</div>
              <div class="patient-sub">QuickMed Team</div>
              <div class="patient-sub">RCC number: (<?php echo e($doctor->rccNumber); ?>)</div>
              <div class="patient-sub">GLN number: (<?php echo e($doctor->glnNumber); ?>)</div>
              <div class="patient-sub"><?php echo e($doctor->homeAddress); ?></div>
              
              <div class="doc_signature">
                <img src="<?php echo e('https://quickmed.technoderivation.com/admin/public/app/' . $doctor->signatureImage); ?>">
                
              </div>
            </div>
            
          </div>

        </div>
      </div>
    </div>`;

    showPreview(html, "referralForm");
}

function previewSickNote() {
    const fields = [
        { id: "Reason_for_Absences", msg: "Reason is required" },
        { id: "Start_Date_of_Absences", msg: "Start date is required" },
        { id: "End_Date_of_Absences", msg: "End date is required" },
        { id: "Return_Dates", msg: "Return date is required" },
        // { id: "Times", msg: "Time is required" }
    ];

    if (!validateFields(fields, "SickNoteForm")) return;

    const start = document.getElementById("Start_Date_of_Absences");
    const end = document.getElementById("End_Date_of_Absences");
    const ret = document.getElementById("Return_Dates");

    let hasError = false;
    if (new Date(end.value) < new Date(start.value)) {
        showFieldError(end, "End date must be after or equal to start date.");
        hasError = true;
    }
    if (new Date(ret.value) < new Date(end.value)) {
        showFieldError(ret, "Return date must be after or equal to end date.");
        hasError = true;
    }
    if (hasError) return;

    const f = document.getElementById("SickNoteForm");
    const html = `
        <div class="modal-body">
      <div class="report-card" role="document" aria-label="Sick Note Report">

        <div class="report-head">
          <div class="report-icon" aria-hidden="true">📝</div>
          <div class="report-title">SICK NOTE</div>
          <div style="flex:1"></div>
        </div>

        <div class="report-content">
          <div class="patient-meta">
            <div class="left-meta">
              <div class="patient-name"><?php echo e($patient->firstName); ?> <?php echo e($patient->lastName); ?></div>
              <div class="patient-sub"><?php echo e($patient->dob ?? 'N/A'); ?></div>
              <div class="patient-sub"><?php echo e($patient->contactNumber ?? 'N/A'); ?></div>
            </div>
          </div>

          <ul class="report-list">
            <li><div class="bullet"></div><div><span class="list-title">Reason</span><span class="list-text"> - ${f.Reason_for_Absence.value}</span></div></li>
             <li><div class="bullet"></div><div><span class="list-title">Start Date</span><span class="list-text"> - ${formatDate(f.Start_Date_of_Absence.value)}</span></div></li>
            <li><div class="bullet"></div><div><span class="list-title">End Date</span><span class="list-text"> - ${formatDate(f.End_Date_of_Absence.value)}</span></div></li>
            <li><div class="bullet"></div><div><span class="list-title">Return Date</span><span class="list-text"> - ${formatDate(f.Return_Date.value)}</span></div></li>
            
          </ul>

          <div class="doctor-meta">
            <div class="left-meta">
              <div class="patient-name">Dr. <?php echo e($doctor->firstName); ?> <?php echo e($doctor->lastName); ?></div>
              <div class="patient-sub">QuickMed Team</div>
              <div class="patient-sub"><?php echo e($doctor->homeAddress); ?></div>
              <div class="patient-sub">RCC number: (<?php echo e($doctor->rccNumber); ?>)</div>
            </div>
            <div class="signature-text">
              <img src="<?php echo e('https://quickmed.technoderivation.com/admin/public/app/' . $doctor->signatureImage); ?>" alt="Doctor Signature">
              
            </div>
          </div>

        </div>
      </div>
    </div>
    `;
    showPreview(html, "SickNoteForm");
}


 function openLogoutModal() {
            document.getElementById("logoutModal").style.display = "flex";
        }

        function closeLogoutModal() {
            document.getElementById("logoutModal").style.display = "none";
        }

        function confirmLogout() {
            document.getElementById("logout-form").submit();
        }

     
// Health Insurance modal
const healthModal = document.getElementById('healthModal');
const healthBtn = document.getElementById('healthInsuranceBtn');

healthBtn.addEventListener('click', function(e) {
    e.preventDefault();
    healthModal.style.display = 'flex';
});

function closeHealthModal() {
    healthModal.style.display = 'none';
}

healthModal.addEventListener('click', function(e) {
    if (e.target === healthModal) {
        closeHealthModal();
    }
});

// Appointment Images modal
const imageModal = document.getElementById('imageModal');
const appointmentBtn = document.getElementById('appointmentBtn');

appointmentBtn.addEventListener('click', function(e) {

  // alert();
    e.preventDefault();
    imageModal.style.display = 'flex';
});

function closeImageModal() {
    imageModal.style.display = 'none';
}

imageModal.addEventListener('click', function(e) {
    if (e.target === imageModal) {
        closeImageModal();
    }
});

document.querySelectorAll('.consult-card').forEach(card => {
    card.addEventListener('click', function() {
        const type = this.getAttribute('data-type');
        const data = JSON.parse(this.getAttribute('data-item'));
        openPastConsultForm(type, data);
    });
});
   



document.addEventListener('DOMContentLoaded', function() {

    // Event delegation for dynamically added/updated cards
    document.getElementById('pastConsultSection').addEventListener('click', function(e) {
        let card = e.target.closest('.consult-card');
        if(!card) return;
  
        const type = card.getAttribute('data-type');
        const data = JSON.parse(card.getAttribute('data-item'));
        openPastConsultForm(type, data);
    });



    // New Consult / Back buttons
    const pastSection = document.getElementById("pastConsultSection");
    const newSection = document.getElementById("newConsultSection");
    const consultButtons = document.getElementById("consultButtons");
    const backArrow = document.getElementById("backToConsults");

    
    document.getElementById("newConsultBtn").addEventListener("click", () => {
        pastSection.style.display = "none";
        consultButtons.style.display = "none";
        newSection.style.display = "block";
        newSection.style.marginTop = "0"; 
    });

    backArrow.addEventListener("click", () => {
        newSection.style.display = "none";
        consultButtons.style.display = "flex"; 
        pastSection.style.display = "block";
    });




    // Tabs functionality
    const tabs = document.querySelectorAll(".tabs .tab");
    const sections = ["reportSection", "prescriptionSection", "referralSection", "sicknoteSection"];

    tabs.forEach(tab => {
        tab.addEventListener("click", () => {
            tabs.forEach(t => t.classList.remove("active"));
            sections.forEach(id => document.getElementById(id).style.display = "none");

            tab.classList.add("active");
            document.getElementById(tab.dataset.target).style.display = "block";
        });
    });
});

// Open past consult forms dynamically
function openPastConsultForm(type, data) {
    const pastSection = document.getElementById("pastConsultSection");
    const newSection = document.getElementById("newConsultSection");
    const consultButtons = document.getElementById("consultButtons");

    pastSection.style.display = "none";
    consultButtons.style.display = "none";
    newSection.style.display = "block";

    const sections = ["reportSection", "prescriptionSection", "referralSection", "sicknoteSection"];
    sections.forEach(id => document.getElementById(id).style.display = "none");

    const tabs = document.querySelectorAll(".tabs .tab");
    tabs.forEach(t => t.classList.remove("active"));

    if (type === "Medical Report" || type === "App\\Models\\PatientsMedicalReport") {
        document.querySelector('[data-target="reportSection"]').classList.add("active");
        document.getElementById("reportSection").style.display = "block";
        fillMedicalReportForm(data);
    }
    if (type === "Prescription" || type === "App\\Models\\Prescription") {
        document.querySelector('[data-target="prescriptionSection"]').classList.add("active");
        document.getElementById("prescriptionSection").style.display = "block";
        fillPrescriptionForm(data);
    }
    if (type === "Referral" || type === "App\\Models\\PatientsRefferal") {
        document.querySelector('[data-target="referralSection"]').classList.add("active");
        document.getElementById("referralSection").style.display = "block";
        fillReferralForm(data);
    }
    if (type === "Sick Note" || type === "App\\Models\\SickNote") {
        document.querySelector('[data-target="sicknoteSection"]').classList.add("active");
        document.getElementById("sicknoteSection").style.display = "block";
        fillSickNoteForm(data);
    }
}

// Fill forms (readonly optional)
function fillMedicalReportForm(data, readonly = false) {
    const f = document.getElementById("medicalReportForm");
    f.Date_of_Consult.value = data.Date_of_Consult || "";
    // f.Time.value = data.Time || "";
    f.Diagnosis.value = data.Diagnosis || "";
    f.Current_anamnesis.value = data.Current_anamnesis || "";
    f.Treatment.value = data.Treatment || "";
    f.Plan.value = data.Plan || "";
    f.Comorbidities.value = data.Comorbidities || "";
    f.Usual_Treatment.value = data.Usual_Treatment || "";
    f.Allergies.value = data.Allergies || "";

    if(readonly) {
        f.querySelectorAll("input, textarea, select, button").forEach(el => {
            if(el.tagName === "BUTTON") el.style.display = "none";
            else el.disabled = true;
        });
    }
}

function fillPrescriptionForm(data, readonly = false) {
    const f = document.getElementById("prescriptionForm");
    f.Diagnosis.value = data.Diagnosis || "";
    // f.Time.value = data.Time || "";
    if(readonly) disableFormFields(f);
}

function fillReferralForm(data, readonly = false) {
    const f = document.getElementById("referralForm");
    // f.Time.value = data.Time || "";
    // f.referral.value = data.referral || "";
    f.Indication.value = data.Indication || "";
    f.Requested_Referral.value = data.Requested_Referral || "";
    if(readonly) disableFormFields(f);
}

function fillSickNoteForm(data, readonly = false) {
    const f = document.getElementById("SickNoteForm");
    f.Reason_for_Absence.value = data.Reason_for_Absence || "";
    f.Start_Date_of_Absence.value = data.Start_Date_of_Absence || "";
    f.End_Date_of_Absence.value = data.End_Date_of_Absence || "";
    f.Return_Date.value = data.Return_Date || "";
    // f.Time.value = data.Time || "";
    if(readonly) disableFormFields(f);
}

function disableFormFields(form) {
    form.querySelectorAll("input, textarea, select, button").forEach(el => {
        if(el.tagName === "BUTTON") el.style.display = "none";
        else el.disabled = true;
    });
}
</script>

<script type="text/javascript">
   function load() {
     document.getElementById("loader").style.display = "block";
     setTimeout(function() {
        document.getElementById("loader").style.display = "none"; }, 20000);
   }
</script>

    <style>


.add-email {
  position: absolute;
  top: 90px;       /* adjust depending on modal header */
  right: 30px;     /* distance from right */
  background: white;
  color: #13e0e0;
  border: none;
  padding: 4px 14px;
  border-radius: 50%;
  font-size: 26px;
  font-weight: bold;
  cursor: pointer;
}

.addmail {
  display: block;
  margin-left: 15px;   /* left spacing */
  text-align: left;    /* force label to left */
}


.emar{

height: 35px;


}



/* Specific style for Share Prescription modal */
.share-modal-content {
  position: relative;
  background: #fff;
  padding: 20px 25px;
  border-radius: 15px;
  text-align: center;
  width: 35%;       /* wider than default */
  max-width: 900px; /* increase limit */
}

/* ensure modal-content is positioned for absolute child */
.modal-content {
  position: relative;
}



.email-row {
  display: flex;
  align-items: center;
  gap: 8px;
  margin-bottom: 8px;
}

.email-row input {
  flex: 1;
}

.email-row button {
  background: #13e0e0;
  color: white;
  border: none;
  padding: 6px 10px;
  border-radius: 6px;
  cursor: pointer;
}

.email-row button.remove-email {
  background: red;
}

  .modal-overlay {
    position: fixed;
    inset: 0;
    background: rgba(0, 0, 0, 0.5);
    z-index: 9999;
    display: none;
    justify-content: center;
    align-items: center;
  }

  .modal {
    background: #fff;
    padding: 50px;
    border-radius: 15px;
    text-align: center;
    width: 35%;
    max-width: 500px;
  }

  .modal-icon {
    background: rgba(0, 211, 199, 0.1);
    width: 100px;
    height: 100px;
    margin: 10px auto 20px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
  }

  .modal h2 {
    font-size: 28px;
    margin-top: 20px;
  }

  .modal p {
    color: #68707a;
    font-size: 18px;
    margin: 10px 0 30px;
  }

  .modal-buttons {
    display: flex;
    justify-content: center;
    gap: 20px;
    flex-wrap: wrap;
  }

  .modal-buttons button {
    padding: 12px 40px;
    border-radius: 8px;
    cursor: pointer;
    font-size: 16px;
    font-weight: 500;
    border: none;
    transition: background 0.3s ease;
  }

  .btn-no {
    background: #eee;
    color: #000;
  }

  .btn-yes {
    background: #13e0e0;
    color: #fff;
  }

.consult-cards {
  display: grid !important;
  grid-template-columns: repeat(2, minmax(0, 1fr)) !important; /* 2 equal columns */
  gap: 20px !important;
  width: 100%;
}

.consult-card {
  width: 100% !important;   /* make card fill grid cell */
  margin: 0 !important;     /* remove external margins */
  box-sizing: border-box;
}

.consult-arrow {
    position: absolute;
    bottom: 10px;
    right: 10px;
    font-size: 18px;
    color: #666;
    cursor: pointer;
    transition: color 0.2s ease;
}

.consult-arrow:hover {
    color: #000;
}


.consult-header {
    display: flex;
    justify-content: space-between;
    align-items: center;
    margin-bottom: 8px;
}

.consult-title {
    margin: 0;
    font-size: 16px;
    font-weight: 600;
}

.consult-date {
    font-size: 18px;
    color: #666;
}

.patient-spe {
    font-weight: 600;
    font-size: 13px;
    color: #222;
    margin-bottom: 8px;
}

.consult-body p {
    margin: 4px 0;
    font-size: 14px;
    text-align: left;
}


    
.consult-cards {
    display: grid;
    grid-template-columns: repeat(auto-fill, minmax(500px, 1fr));
    gap: 20px;
    margin-top: 20px;
}

.consult-card {
    background: #fff;
    color: #000;
    padding: 20px;
    border-radius: 20px;
    box-shadow: 0 10px 25px rgba(0,0,0,0.2);
    cursor: pointer;
    transition: all 0.3s ease;
    position: relative;
    overflow: hidden;
}

.consult-card::before {
    content: '';
    position: absolute;
    width: 150%;
    height: 150%;
    background: rgba(255, 255, 255, 0.1);
    top: -50%;
    left: -50%;
    transform: rotate(45deg);
    transition: all 0.5s ease;
}

.consult-card:hover::before {
    top: -20%;
    left: -20%;
}

.consult-card:hover {
    transform: translateY(-10px) scale(1.02);
    box-shadow: 0 15px 30px rgba(0,0,0,0.3);
}

.consult-card h4 {
    margin: 0 0 10px;
    font-size: 22px;
    font-weight: bold;
    display: flex;
    align-items: center;
    gap: 8px;
}

.consult-card p {
    margin: 5px 0;
    font-size: 14px;
    line-height: 1.4;
}

/* Add little icons background for variety */
.consult-card[data-type="Medical Report"] {
    background: linear-gradient(135deg, #9b9897ff, #9b9897ff);
}
.consult-card[data-type="Prescription"] {
    background: linear-gradient(135deg, #9b9897ff, #9b9897ff);
}
.consult-card[data-type="Referral"] {
    background: linear-gradient(135deg, #9b9897ff, #9b9897ff);
}
.consult-card[data-type="Sick Note"] {
    background: linear-gradient(135deg, #9b9897ff, #9b9897ff);
}
</style>

<style>
  

  /* outer modal frame that includes title band & close button like screenshot */
  



  .close-btn{
    width:36px;
    height:36px;
    border-radius:50%;
    display:inline-grid;
    place-items:center;
    background:transparent;
    border:2px solid #dfe6e9;
    cursor:pointer;
    transition: all .15s ease;
  }
  .close-btn:hover{
    transform:scale(0.98);
    background:#fafafa;
  }
  .close-btn:before{
    content:"✕";
    font-size:14px;
    color:#555;
        padding: 7px 8px;
  }

  /* content area */


  /* card inside modal */
  .report-card{
    background: linear-gradient(180deg,#fff,#fff);
    border-radius:12px;
    overflow:hidden;
    box-shadow: 0 6px 22px rgba(9,12,15,0.06);
    border: 1px solid rgba(0,0,0,0.03);
  }

  /* top colored header of the report */
  .report-head{
        background: #918c99;
    color: #fff;
    padding: 8px 28px;
    display:flex;
    align-items:center;
    gap:18px;
    position:relative;
  }

  /* small icon badge on left */
  .report-icon{
    width:56px;
    height:56px;
    border-radius:8px;
    background: rgba(255,255,255,0.12);
    display:flex;
    align-items:center;
    justify-content:center;
    font-weight:700;
    font-size:22px;
    flex:0 0 56px;
  }

  .report-title{
    font-size:26px;
    font-weight:700;
    letter-spacing:1px;
  }

  /* inner content */
  .report-content{
    padding:22px 34px;
    position:relative;
    background: #fff;
  }

  /* faint watermark (medical cross + stethoscope) using inline SVG background */
  
  .patient-meta{
    display:flex;
    align-items:flex-start;
    gap:12px;
    justify-content:space-between;
    flex-wrap:wrap;
    margin-bottom:18px;
  }

  .left-meta{
    min-width:260px;
    /*text-align: center;*/
  }

  .patient-name{
    font-weight:600;
    font-size:16px;
    color:#222;
    margin-bottom:8px;
  }
  .patient-sub{
    color:var(--muted);
    font-size:14px;
    margin:4px 0;
    max-width: 250px;
    white-space: normal;
    word-break: break-word;
  }

  .signature-text {
    text-align: right;
    width: 40%;
    color: #a69c9c;
    font-weight: 600;
    align-self: flex-start;
}

  .date-text{
    color:#222;
    font-weight:600;
    align-self:flex-start;
  }

  /* bullet list style */
  .report-list{
    margin:6px 0 0 6px;
    padding:0;
    list-style: none;
  }

  .report-list li{
    display:flex;
    gap:10px;
    margin:20px 0;
    align-items:flex-start;
  }

  .bullet {
        width: 8px;
        height: 12px;
        border-radius: 50%;
        background: #222;
        margin-top: 2px;
        flex: 0 0 12px;
    }

  .list-title{
    font-weight:600;
    color:#222;
    margin-right:6px;
    min-width:160px;
  }

  .list-text{
    color:var(--muted);
  }

  /* small footer spacing so watermark doesn't overlap bottom */
  .report-footer{
    height:18px;
  }

  .doctor-meta {
    display: flex;
    align-items: flex-start;
    gap: 12px;
    justify-content: space-between;
    flex-wrap: wrap;
    margin-bottom: 18px;
    margin-top: 50px;
}

.modal-footer {
    text-align: center;
    margin-bottom: 20px;
}

  /* responsive */
  @media (max-width:520px){
    .modal-frame{ max-width:420px; border-radius:14px; }
    .report-head{ padding:16px 18px; gap:12px; }
    .report-title{ font-size:20px; }
    .report-icon{ width:44px; height:44px; font-size:18px; flex:0 0 44px; border-radius:8px;}
    .report-content{ padding:16px 18px; }
    .report-content::before{ display:none; } /* hide watermark on small screens for clarity */
    .left-meta{ min-width:unset; }
  }
</style>

<script type="text/javascript">
  function pad2(n){ return (n < 10 ? '0' : '') + n; }

function formatDate(value){
  if(!value) return 'N/A';

  // If already in d/m/yy or d/m/yyyy form, normalise
  if(/^\d{1,2}\/\d{1,2}\/\d{2,4}$/.test(value.trim())){
    const parts = value.trim().split('/');
    let day = String(Number(parts[0]));   // remove leading zeros if any
    let month = String(Number(parts[1]));
    let year = parts[2];
    if(year.length === 4) year = year.slice(-2);
    return pad2(Number(day)) + '/' + pad2(Number(month)) + '/' + pad2(Number(year));
  }

  // Try Date parse (accepts ISO like 2025-11-14 or full timestamp)
  let d = new Date(value);
  if(isNaN(d.getTime())){
    // fallback: replace '-' with '/' (some browsers parse better)
    d = new Date(value.replace(/-/g, '/'));
    if(isNaN(d.getTime())) return 'N/A';
  }

  const dd = pad2(d.getDate());
  const mm = pad2(d.getMonth() + 1);
  const yyyy = d.getFullYear();
  return `${dd}/${mm}/${yyyy}`;
}
</script>

</body>

</html><?php /**PATH /home/quickmed/public_html/emr/resources/views/admin/add_prescription.blade.php ENDPATH**/ ?>