<!DOCTYPE html>
<html>
<head>
<meta charset="UTF-8">
<title>Sick Note</title>
</head>
<body style="margin:0; padding:0; background-color:#fff; font-family:Arial, sans-serif; color:#000;">

<table width="100%" border="0" cellspacing="0" cellpadding="0" style="max-width:700px; margin:auto; border:3px solid #444; border-radius:12px;">
  <tr>
    <td style="background-color:#4a4a4a; color:#fff; font-size:22px; font-weight:bold; padding:15px 25px; border-top-left-radius:10px; border-top-right-radius:10px;">
      Sick Note
    </td>
  </tr>

  <tr>
    <td style="padding:20px;">
      <!-- Doctor Info -->
      <table width="100%" border="0" cellspacing="0" cellpadding="0">
        <tr valign="top">
          <td width="60%" style="font-size:14px; line-height:20px;">
            <strong>Dr. <?php echo e($doctor->firstName); ?> <?php echo e($doctor->lastName); ?></strong><br>
           <strong><?php echo e($doctor->specialist); ?></strong><br>
            <?php echo e($doctor->homeAddress); ?><br><br>
            TEL: <?php echo e($doctor->countryCode); ?> <?php echo e($doctor->contactNumber); ?><br>
            GLN : <?php echo e($doctor->glnNumber); ?><br>
          </td>
          <td width="40%" align="right" style="font-size:14px;">
            <strong>Date:</strong> <?php echo e(\Carbon\Carbon::now()->format('d/m/Y')); ?>

          </td>
        </tr>
      </table>

      <hr style="border:1px solid #000; margin:15px 0;">

      <!-- Patient Info -->
      <table width="100%" border="0" cellspacing="0" cellpadding="0">
        <tr>
          <?php
              $gender = ($patient->gender == 'Male') ? 'Mr.' : 'Ms.';
          ?>
          
          <td width="100%"  style="font-size:14px;height: 100px;text-align:center;float:right">
            <span style="text-align: center;"><?php echo e($gender); ?><span><br>
            <strong><?php echo e($patient->firstName); ?> <?php echo e($patient->lastName); ?></strong><br>
            <?php echo e($patient->homeAddress); ?>

          </td>
          <br>
         

        </tr>

        <tr > 
          
          <td width="100%" align="left" style="font-size:14px;;height: 100px;">
            <strong>Date of Birth:</strong> <?php echo e($patient->dob); ?><br>
            <strong>Reason:</strong> illness
          </td>


        </tr>
      </table>

      <p style="text-align:center; font-weight:bold; text-decoration:underline; font-size:18px; margin:25px 0;">Sick Note</p>

      <p>   
        This is to certify that <strong><?php echo e($patient->firstName); ?></strong>  
        has been advised rest due to <strong><?php echo e($note->Reason_for_Absence); ?></strong>  
        from <strong><?php echo e(\Carbon\Carbon::parse($note->Start_Date_of_Absence)->format('d/m/Y')); ?></strong>  
        to <strong><?php echo e(\Carbon\Carbon::parse($note->End_Date_of_Absence)->format('d/m/Y')); ?></strong>.  
        May return on <strong><?php echo e(\Carbon\Carbon::parse($note->Return_Date)->format('d/m/Y')); ?></strong>.
    </p>

      <!-- Bottom Doctor Info -->
      <div style="margin-top:50px; font-size:14px;">
        <strong>Dr. <?php echo e($doctor->firstName); ?> <?php echo e($doctor->lastName); ?></strong><br>
        <!-- <strong>( <?php echo e($doctor->specialist); ?> )</strong><br> -->
        RCC : <?php echo e($doctor->rccNumber); ?><br><br>
       
        <img src="https://quickmed.technoderivation.com/admin/public/app/<?php echo e($doctor->signatureImage); ?>" 
     alt="Doctor Signature" style="width:120px; height:auto; border:1px solid #ccc;margin-top:10px;">

      </div>
    </td>
  </tr>
</table>

</body>
</html>
<?php /**PATH /home/quickmed/public_html/emr/resources/views/pdf/sicknote.blade.php ENDPATH**/ ?>