<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>Quickmed</title>
    <link href="https://cdn.jsdelivr.net/npm/remixicon@3.5.0/fonts/remixicon.css" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('Assets/style.css')); ?>" />
    <link rel="shortcut icon" href="<?php echo e(asset('Assets/Fav-icon.png')); ?>" type="image/x-icon">
</head>

<body>

    <div class="container">

        <!-- Sidebar -->
        <aside class="sidebar">
            <div class="logo-section">
                <img src="<?php echo e(asset('Assets/sidebar-logo.png')); ?>" alt="QuickMed Logo">
                <hr>
            </div>
            <nav class="menu">
                <a href="<?php echo e(route('admin.index')); ?>" class="active">
                    <i class="ri-user-line"></i> Patients
                </a>
            </nav>

            <!-- Logout Section -->
            <div class="logout">
                <!-- Hidden form -->
                <form id="logout-form" action="<?php echo e(route('doctor.logout')); ?>" method="POST" style="display:none;">
                    <?php echo csrf_field(); ?>
                </form>

                <!-- Logout link opens modal -->
                <a href="#" onclick="event.preventDefault(); openLogoutModal();">
                    <img src="<?php echo e(asset('Assets/logout.svg')); ?>" alt="log-out"> Log Out
                </a>
            </div>
        </aside>

        <!-- Right Content -->
        <div class="right-page">
            <div class="header-row">
                <div class="header-left">
                    <i class="ri-menu-line sidebar-toggle"></i>
                    <h1>Patients</h1>
                </div>

                <div style="display: flex; align-items: center; gap: 10px;">

                    <?php if(!empty($doctor->profilePath)): ?>
                      <img src="https://quickmed.technoderivation.com/admin/public/app/<?php echo e($doctor->profilePath); ?>" alt="Profile" class="profile-img"
                         style="width: 40px; height: 40px; border-radius: 50%;">  
                    <?php else: ?>
                     <img src="https://quickmed.technoderivation.com/admin/public/uploads/no_image.jpg" alt="Profile" class="profile-img"
                         style="width: 40px; height: 40px; border-radius: 50%;">  
                    <?php endif; ?>
                    
                    




                    <div style="display: flex; flex-direction: column; line-height: 1.2;">
                        <span style="font-weight: bold;"><?php echo e($doctor->firstName); ?> <?php echo e($doctor->lastName); ?></span>
                        <span style="font-size: 12px; color: #999999;">Doctor</span>
                    </div>
                </div>
            </div>

            <hr>

            <!-- Search Box -->
            <div class="tabs-search">
                <div class="search-box">
                    <input type="text" placeholder="Search">
                    <i class="ri-search-line"></i>
                </div>

            </div>

            <style>
                
.search-box {
    position: relative;
    display: inline-block;
    width: 300px; /* adjust as needed */
}

.search-box input {
    width: 100%;
    padding: 10px 12px 10px 40px; /* space on left for icon */
    border: 1px solid #ccc;
    border-radius: 6px;
    font-size: 14px;
}

.search-box i {
    position: absolute;
    left: 12px;   /* icon on the left */
    top: 50%;
    transform: translateY(-50%);
    color: #666;
    font-size: 18px;
    pointer-events: none; /* lets user click/type without issue */
}
</style>

            <!-- Patients Table -->
            <div class="table-container" style="overflow-x: auto; max-width: 100%;">
                <table id="patientsTable" style="min-width: 1600px; width: max-content;">
                    <thead>
                        <tr>
                            <th>Sr. No.</th>
                            <th>Patient Name</th>
                            <th>Canton</th>
                            <th>Age</th>
                            <th>Email</th>
                            <th>Language</th>
                            <th>Medical Problem</th>
                            <th>Describe your problem</th>
                            <th>Status</th>
                            <th>Request</th>
                            
                            <th>Consult Date</th>     
                            <th>Action</th>
                        </tr>
                    </thead>
                    <tbody>
                        <?php $__currentLoopData = $consults; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $consult): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td><?php echo e(($consults->firstItem() ?? 0) + $loop->index); ?></td>
                                <td> <a href="<?php echo e(route('admin.detail', ['id' => $consult->id])); ?>"><b><?php echo e($consult->firstName); ?> <?php echo e($consult->lastName); ?></b></a></td>
                                <td>

                                    <?php if(!empty($consult->canton)): ?>
                                        <?php echo e($consult->canton); ?>

                                    <?php else: ?>
                                        --
                                    <?php endif; ?>
                                    
                                    

                                </td>


                                <td>
                                    <?php if(!empty($consult->age)): ?> 
                                    <span><?php echo e($consult->age); ?> Year </span>
                                    <?php else: ?>
                                    <span><?php echo e(\Carbon\Carbon::parse($consult->dob)->age); ?> Year</span>
                                    <?php endif; ?>  
                                </td>                

                                <td><?php echo e($consult->email); ?></td>
                                <td><?php echo e($consult->language); ?></td>
                                <td>
                                    <?php if($consult->language == 'English'): ?>
                                        <span><?php echo e($consult->enName ?? 'N/A'); ?></span>

                                    <?php elseif($consult->language == 'Français'): ?>
                                        <span><?php echo e($consult->frName ?? 'N/A'); ?></span>

                                    <?php elseif($consult->language == 'Italiano'): ?>
                                        <span><?php echo e($consult->itName ?? 'N/A'); ?></span>

                                    <?php elseif($consult->language == 'German'): ?>
                                        <span><?php echo e($consult->deName ?? 'N/A'); ?></span>

                                    <?php else: ?>
                                        <span><?php echo e($consult->enName ?? 'N/A'); ?></span> 
                                    <?php endif; ?>

                                    
                                   

                                </td>
                                <td><?php echo e($consult->description); ?></td>

                                <td><?php echo e($consult->status); ?></td>

                                <td>
                                    <?php if($consult->payment_method == 'Stripe'): ?>
                                        <span style="border-radius: 10px;background: green;color: #fff;padding: 5px 5px;font-size: 12px;">Paid on app : <?php echo e($consult->currency); ?> <?php echo e($consult->total_amount); ?></span>
                                    <?php else: ?>
                                        <span style="border-radius: 10px;background: red;color: #fff;padding: 5px 5px;font-size: 12px;">Health Insurence</span> 
                                    <?php endif; ?>
                                </td>


                                <td><?php echo e(\Carbon\Carbon::parse($consult->createdAt)->format('d M, Y H:i:s')); ?></td>
                                <td>  
                                    <a href="<?php echo e(route('admin.detail', ['id' => $consult->id])); ?>">
                                        <div class="action-icon">
                                            <i class="ri-eye-line"></i>
                                        </div>
                                    </a>
                                </td>
                            </tr>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>      
                    </tbody>
                </table>
            </div>

            <div class="custom-pagination">
                <span class="pagination-info">
                    Showing <?php echo e($consults->firstItem()); ?> to <?php echo e($consults->lastItem()); ?> of <?php echo e($consults->total()); ?> results
                </span>
                <div class="pagination-controls">
                    <?php echo e($consults->appends(request()->query())->links('vendor.pagination.custom')); ?>

                </div>
            </div>

            <!-- <div class="pagination">
                <?php echo e($consults->links()); ?>

            </div> -->


            <!-- Pagination -->
            <!-- <div class="pagination">
                <?php echo e($consults->links()); ?>

                <span>Showing 10 out of 13 results</span>
                <div class="page-controls">
                    <select>
                        <option>10</option>
                        <option>20</option>
                        <option>30</option>
                        <option>40</option>
                    </select>
                    <button><i class="ri-arrow-left-s-line"></i></button>
                    <button class="active">1</button>
                    <button class="page-number">2</button>
                    <button><i class="ri-arrow-right-s-line"></i></button>
                </div>
            </div> -->
        </div>
    </div>

    <!-- Logout Modal -->
<div class="modal-overlay" id="logoutModal" style="display: none;">
  <div class="modal">
    <div class="modal-icon">
      <img src="<?php echo e(asset('Assets/logout-image.png')); ?>" alt="Logout Icon" style="width: 150px; height: 150px;">
    </div>

    <h2>Are you Leaving?</h2>
    <p>Are you sure you want to Log Out?</p>
    <div class="modal-buttons">
      <button class="btn-no" id="cancelLogout">No</button>
      <form id="logout-form" action="<?php echo e(route('doctor.logout')); ?>" method="POST">
        <?php echo csrf_field(); ?>
        <button type="submit" class="btn-yes">Yes</button>
      </form>
    </div>
  </div>
</div>

<?php if(session('login_success')): ?>
    <div id="toast" class="toast-success">
        <span class="icon">✅</span>
        <span><?php echo e(session('login_success')); ?></span>
        <button class="close-btn" onclick="document.getElementById('toast').style.display='none'"></button>
    </div>

    <script>
        // Auto-hide toast after 5 seconds
        setTimeout(() => {
            const toast = document.getElementById('toast');
            if (toast) {
                toast.style.opacity = "0";
                toast.style.transform = "translateY(-20px)";
                setTimeout(() => toast.remove(), 500);
            }
        }, 5000);
    </script>
<?php endif; ?>

<style>

      .toast-success {
  position: fixed;
  top: 20px;
  right: 20px;
  background: #fff;
  color: #333;
  padding: 14px 20px;
  border-radius: 6px;
  border-left: 5px solid #4CAF50; /* green bar */
  box-shadow: 0px 4px 10px rgba(0,0,0,0.15);
  display: flex;
  align-items: center;
  gap: 10px;
  z-index: 9999;
  animation: fadeIn 0.4s ease;
  transition: all 0.4s ease;
  min-width: 300px;
  max-width: 350px;
}

.toast-success .icon {
  color: #4CAF50;
  font-size: 18px;
}
.pagination nav {
    display: flex;
    justify-content: right;
    align-items: center;
    margin-top: 15px;
    gap: 6px;
}

.pagination nav a,
.pagination nav span {
    display: inline-block;
    padding: 6px 12px;
    margin: 0 3px;
    border: 1px solid #ddd;
    border-radius: 5px;
    text-decoration: none;
    color: #333;
    font-size: 14px;
    transition: all 0.2s ease-in-out;
}

.pagination nav a:hover {
    background-color: #f0f0f0;
}

.pagination nav .active {
    background-color: #007bff;
    color: #fff;
    border-color: #007bff;
    font-weight: bold;
}

.pagination nav .disabled {
    color: #aaa;
    cursor: not-allowed;
    background-color: #f8f8f8;
}


  .modal-overlay {
    position: fixed;
    inset: 0;
    background: rgba(0, 0, 0, 0.5);
    z-index: 9999;
    display: none;
    justify-content: center;
    align-items: center;
  }

  .modal {
    background: #fff;
    padding: 50px;
    border-radius: 15px;
    text-align: center;
    width: 35%;
    max-width: 500px;
  }

  .modal-icon {
    background: rgba(0, 211, 199, 0.1);
    width: 100px;
    height: 100px;
    margin: 10px auto 20px;
    border-radius: 50%;
    display: flex;
    align-items: center;
    justify-content: center;
  }

  .modal h2 {
    font-size: 28px;
    margin-top: 20px;
  }

  .modal p {
    color: #68707a;
    font-size: 18px;
    margin: 10px 0 30px;
  }

  .modal-buttons {
    display: flex;
    justify-content: center;
    gap: 20px;
    flex-wrap: wrap;
  }

  .modal-buttons button {
    padding: 12px 40px;
    border-radius: 8px;
    cursor: pointer;
    font-size: 16px;
    font-weight: 500;
    border: none;
    transition: background 0.3s ease;
  }

  .btn-no {
    background: #eee;
    color: #000;
  }

  .btn-yes {
    background: #10d9d0;
    color: #fff;
  }

  
</style>

<script>
  function openLogoutModal() {
    document.getElementById("logoutModal").style.display = "flex";
  }

  document.getElementById("cancelLogout").addEventListener("click", function () {
    document.getElementById("logoutModal").style.display = "none";
  });
</script>


    <div class="overlay"></div>

    <script>
        // Sidebar toggle
        const toggleBtn = document.querySelector('.sidebar-toggle');
        const sidebar = document.querySelector('.sidebar');
        const overlay = document.querySelector('.overlay');

        toggleBtn.addEventListener('click', () => {
            sidebar.classList.toggle('open');
            overlay.style.display = sidebar.classList.contains('open') ? 'block' : 'none';
        });

        overlay.addEventListener('click', () => {
            sidebar.classList.remove('open');
            overlay.style.display = 'none';
        });

        // Logout modal functions
       
  


    </script>
    
    <!-- Search Filter -->
    <script>
        const searchInput = document.querySelector('.search-box input');
        const table = document.getElementById('patientsTable');
        const rows = table.getElementsByTagName('tbody')[0].getElementsByTagName('tr');

        searchInput.addEventListener('input', function() {
            const filter = this.value.toLowerCase();

            for (let i = 0; i < rows.length; i++) {
                const cells = rows[i].getElementsByTagName('td');
                let match = false;

                for (let j = 0; j < cells.length - 1; j++) { 
                    if (cells[j].textContent.toLowerCase().includes(filter)) {
                        match = true;
                        break;
                    }
                }

                rows[i].style.display = match ? '' : 'none';
            }
        });
    </script>

</body>
</html>
<?php /**PATH /home/quickmed/public_html/emr/resources/views/admin/index.blade.php ENDPATH**/ ?>