<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\Treatment;
use Illuminate\Support\Facades\App;
use Illuminate\Support\Facades\DB;

class PatientsController extends Controller
{
    public function index()
    {
        $locale = App::getLocale();

        // Set localized columns
        $nameField = "{$locale}Name";
        $descField = "{$locale}Description";

        // Fetch only 'symptom' type treatments in A-Z order
        $treatments = Treatment::select(
            'id',
            DB::raw("COALESCE($nameField, enName) as name")
        )
            ->where('type', 'Symptom')  // 👈 only 'symptom' records
            ->orderBy('name', 'asc')
            ->get();

        // ✅ Fetch Medications (Prescribe & Treat)
        $medications = DB::table('tbl_medical_problem_list')
            ->select(
                DB::raw("COALESCE($nameField, enName) as name"),
                DB::raw("COALESCE($descField, enDescription) as description"),
                'image',
                'type'
            )
            ->whereIn('type', ['Prescribe', 'Treat'])
            ->get();

        // ✅ Fetch Doctors
        $doctors = DB::table('tbl_doctor_list')
            ->select(
                'id',
                'profilePath',
                DB::raw("COALESCE($nameField, enName) as name"),
                DB::raw("COALESCE($descField, enDescription) as description")
            )
            ->orderBy('name', 'asc')
            ->get();

        // ✅ Pass all data to view
        return view('for_patients', compact('doctors', 'treatments', 'medications'));
    }
}
