<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">

<head>
    <meta charset="UTF-8">
    <title>Language Switch</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>

<body>
    <div class="dropdown">
        <button class="btn btn-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown">
            🌐 {{ strtoupper(app()->getLocale()) }}
        </button>
        <ul class="dropdown-menu">
            <li><a class="dropdown-item" href="{{ url('lang/en') }}">English</a></li>
            <li><a class="dropdown-item" href="{{ url('lang/hi') }}">हिन्दी</a></li>
        </ul>
    </div>


    <p>Current locale: {{ App::getLocale() }}</p>
    <h4><img src="images/header/img2.png"> {{ __('messages.health_priority') }}</h4>
    <h1>
        {{ __('messages.consult_title') }}<br>
        {{ __('messages.anywhere') }}
        <span class="highlight">{{ __('messages.in_switzerland') }}</span>
    </h1>
    <p>{{ __('messages.connect_text') }}</p>
    <p class="text">{{ __('messages.download_app') }}</p>



    <div class="app-buttons">
        <a href="javascript:void(0);">
            <img src="https://developer.apple.com/assets/elements/badges/download-on-the-app-store.svg" alt="App Store">
        </a>
        <a href="javascript:void(0);">
            <img src="https://upload.wikimedia.org/wikipedia/commons/7/78/Google_Play_Store_badge_EN.svg" alt="Google Play" class="google">
        </a>
    </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html>