<!DOCTYPE html>
<html lang="{{ app()->getLocale() }}">

<head>
    <meta charset="UTF-8">
    <title>QuickMed Header</title>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.css" />

    <link rel="stylesheet" href="plugins/bootstrap/bootstrap.min.css">
    </link>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@10/swiper-bundle.min.css">
    <link rel="stylesheet" href="assests/style.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Mukta:wght@200;300;400;500;600;700;800&display=swap"
        rel="stylesheet">
            <link rel="shortcut icon" href="public/Fav-icon.png" type="image/x-icon">

</head>

<body>

    <nav class="navbar navbar-expand-lg bg-body-tertiary">
        <div class="container">
            <img src="images/header/logo.svg" alt="Logo" class="logo">

            <div class="collapse navbar-collapse" id="navbarSupportedContent">


                <ul class="topbar me-auto mb-2 mb-lg-0">
                    <li class="nav-item">
                        <a class="nav-link" href="#">{{ __('messages.nav.home') }}</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#about_us">{{ __('messages.nav.about') }}</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#team">{{ __('messages.nav.medical') }}</a>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            {{ __('messages.nav.symptoms') }}
                        </a>
                        <ul class="dropdown-menu custom-dropdown">
                            @foreach($treatments as $treatment)
                            <li><a class="dropdown-item" href="#">{{ $treatment->name }}</a></li>
                            @endforeach
                        </ul>
                    </li>
                </ul>

            </div>

            <div class="d-flex">
                <div class="right-section">
                    <div class="nav-buttons d-flex gap-2">
                        <a href="{{ route('patients') }}" class="btn btn-doctors">{{ __('messages.for_doctors') }}</a>
                        <a href="#contact" class="btn btn-contact">{{ __('messages.contact_us') }}</a>

                    </div>


                    @php
                    $locale = app()->getLocale();
                    $flag = $locale === 'fr' ? 'img6.png' : 'img5.png';
                    $alt = $locale === 'fr' ? 'French' : 'English';
                    @endphp

                    <div class="btn-group">
                        <button type="button" class="btn btn-secondary dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                            <img src="{{ asset('images/header/' . $flag) }}" alt="{{ $alt }}" class="language-flag">
                        </button>
                        <ul class="dropdown-menu dropdown-menu-end">
                            <li>
                                <a class="dropdown-item" href="{{ url('lang/en') }}">
                                    <img src="{{ asset('images/header/img5.png') }}" alt="English" class="language-flag"> English
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item" href="{{ url('lang/fr') }}">
                                    <img src="{{ asset('images/header/img6.png') }}" alt="French" class="language-flag"> French
                                </a>
                            </li>
                        </ul>
                    </div>



                </div>
                <button class="navbar-toggler collapsed" type="button" data-bs-toggle="collapse"
                    data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent"
                    aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                    <i class="fa-solid fa-circle-xmark"></i>
                </button>
                <div>
                </div>
    </nav>



    <section class="banner"
        style="background: url(images/banner/img2.png); background-size: cover; background-repeat: no-repeat;">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-xl-7 col-lg-7 col-md-12 mb-4 order-xl-1 order-lg-2 order-2">
                    <div class="content">
                        <h4>
                            <img src="images/header/img2.png"> {{ __('messages.priority') }}
                        </h4>
                        <h1>
                            {{ __('messages.consult') }} <br>
                            {{ __('messages.anywhere') }}
                            <span class="highlight">{{ __('messages.switzerland') }}</span>
                        </h1>
                        <p>{{ __('messages.description') }}</p>
                        <p class="text">{{ __('messages.download') }}</p>

                        <div class="app-buttons">
                            <a href="javascript:void(0);">
                                <img src="https://developer.apple.com/assets/elements/badges/download-on-the-app-store.svg" alt="App Store">
                            </a>
                            <a href="javascript:void(0);">
                                <img src="https://upload.wikimedia.org/wikipedia/commons/7/78/Google_Play_Store_badge_EN.svg" alt="Google Play" class="google">
                            </a>
                        </div>
                    </div>

                </div>
                <div class="col-xl-5 col-lg-5 col-md-12 order-xl-1 order-lg-1 order-1">
                    <div class="image ">
                        <img src="images/banner/img1.png" alt="QuickMed Phone">
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="support-section" id="about_us">
        <div class="container-fluid">
            <div class="row " style=" justify-content: space-between;">
                <div class="col-xl-6">
                    <div class="image-wrapper m-b30">
                        <img src="images/about-us/img1.png" alt="Doctor with patient">
                    </div>
                </div>
                <div class="col-xl-6">

                    <div class="text-content">
                        <h5>{{ __('messages.about') }}</h5>
                        <h2>{{ __('messages.support_heading') }} <span class="highlight">{{ __('messages.support_highlight') }}</span> {{ __('messages.support_you') }}</h2>
                        <ul class="support-list">
                            <li><i class="fa-solid fa-circle-check"></i> {{ __('messages.support_1') }}</li>
                            <li><i class="fa-solid fa-circle-check"></i> {{ __('messages.support_2') }}</li>
                            <li><i class="fa-solid fa-circle-check"></i> {{ __('messages.support_3') }}</li>
                            <li><i class="fa-solid fa-circle-check"></i> {{ __('messages.support_4') }}</li>
                            <li><i class="fa-solid fa-circle-check"></i> {{ __('messages.support_5') }}</li>
                            <li><i class="fa-solid fa-circle-check"></i> {{ __('messages.support_6') }}</li>
                        </ul>
                    </div>

                </div>
            </div>
        </div>
    </section>

    <section class="hours-section overflow-hidden">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-4">
                    <div class="left-content overflow-hidden">
                        <h5>{{ __('messages.about_us') }}</h5>
                        <h2>{!! __('messages.open_hours_title') !!}</h2>
                        <ul class="hours-list">
                            <li><i class="fa-regular fa-calendar"></i> {{ __('messages.mon_to_fri') }}</li>
                            <li><i class="fa-regular fa-calendar"></i> {{ __('messages.sunday') }}</li>
                            <li><i class="fa-regular fa-circle-xmark"></i> {{ __('messages.saturday_closed') }}</li>
                            <li><i class="fa-regular fa-calendar-check"></i> {{ __('messages.public_holiday') }}</li>
                        </ul>
                    </div>

                </div>
                <div class="col-lg-8">
                    <div class="right-content">
                        <div class="swiper mySwiper2 overflow-hidden">
                            <div class="swiper-wrapper">
                                <div class="swiper-slide card">
                                    <img src="images/service/img1.png" alt="Prescriptions">
                                    <p>{{ __('messages.slider.prescriptions') }}</p>
                                </div>
                                <div class="swiper-slide card">
                                    <img src="images/service/img2.png" alt="Referrals to specialists">
                                    <p>{{ __('messages.slider.specialists') }}</p>
                                </div>
                                <div class="swiper-slide card">
                                    <img src="images/service/img3.png" alt="Lab referrals">
                                    <p>{{ __('messages.slider.laboratory') }}</p>
                                </div>
                                <div class="swiper-slide card">
                                    <img src="images/service/img4.png" alt="Prescriptions">
                                    <p>{{ __('messages.slider.referrals_to_imaging_studies') }}</p>
                                </div>
                                <div class="swiper-slide card">
                                    <img src="images/service/img5.png" alt="Referrals to specialists">
                                    <p>{{ __('messages.slider.sick_notes') }}</p>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>


        </div>
    </section>

    <section class="no-prescribe-section overflow-hidden">
        <div class="container-fluid">
            <div class="row">
                <div class="col-xl-6 col-lg-8 order-xl-1 order-lg-2 order-2">
                    <div class="media-content m-b30">


                        <div class="medication-list">
                            @foreach($medications->where('type', 'Prescribe') as $medication)
                            <div class="medication-item img-box">
                                <div class="ss-media">
                                    <img src="{{ asset('public/uploads/' . $medication->image) }}" alt="{{ $medication->name }}">
                                </div>
                                <div>
                                    <strong>{{ $medication->name }}</strong>
                                    <p>{{ $medication->description }}</p>
                                </div>
                            </div>
                            @endforeach
                        </div>

                    </div>
                </div>
                <div class="col-xl-6 col-lg-4 order-xl-2 order-lg-1 order-1">
                    <div class="right-content sticky-top">
                        <h5>{{ __('messages.medications_title') }}</h5>
                        <h2>{{ __('messages.medications_heading') }} <span class="highlight">{{ __('messages.medications_highlight') }}</span></h2>
                        <p class="subtext">{{ __('messages.medications_subtext') }}</p>
                        <div class="sticky-image m-b30">
                            <img src="images/medication/img1.png" alt="Doctor explaining medication" />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="problems-section overflow-hidden">
        <div class="container-fluid">
            <h5>{{ __('messages.services.title') }}</h5>
            <h2>{{ __('messages.services.subtitle.part1') }} <span class="highlight">{{ __('messages.services.subtitle.highlight') }}</span> {{ __('messages.services.subtitle.part2') }}</h2>


            <div class="swiper problemsSwiper overflow-visible">
                <div class="swiper-wrapper">
                    <div class="swiper-slide problem-chip">{{ __('messages.bronchitis') }}</div>
                    <div class="swiper-slide problem-chip">{{ __('messages.covid') }}</div>
                    <div class="swiper-slide problem-chip">{{ __('messages.coughs_colds') }}</div>
                    <div class="swiper-slide problem-chip">{{ __('messages.earaches') }}</div>
                    <div class="swiper-slide problem-chip">{{ __('messages.flu') }}</div>
                    <div class="swiper-slide problem-chip">{{ __('messages.bp') }}</div>
                    <div class="swiper-slide problem-chip">{{ __('messages.sore_throat') }}</div>
                    <div class="swiper-slide problem-chip">{{ __('messages.muscle') }}</div>
                    <div class="swiper-slide problem-chip">{{ __('messages.pinworms') }}</div>
                    <div class="swiper-slide problem-chip">{{ __('messages.poison_ivy') }}</div>
                    <div class="swiper-slide problem-chip">{{ __('messages.respiratory') }}</div>
                    <div class="swiper-slide problem-chip">{{ __('messages.sinus') }}</div>
                    <div class="swiper-slide problem-chip">{{ __('messages.rashes') }}</div>
                    <div class="swiper-slide problem-chip">{{ __('messages.stomach') }}</div>
                    <div class="swiper-slide problem-chip">{{ __('messages.tick_bites') }}</div>
                    <div class="swiper-slide problem-chip">{{ __('messages.utis') }}</div>
                    <div class="swiper-slide problem-chip">{{ __('messages.yeast') }}</div>
                   
                </div>

            </div>
        </div>
    </section>

    <section class="no-prescribe-section overflow-hidden">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-6">
                    <div class="right-content sticky-top">
                        <h5>{{ __('messages.problems.title') }}</h5>
                        <h2>
                            {{ __('messages.problems.heading.part1') }}
                            <span class="highlight">{{ __('messages.problems.heading.part2') }}</span>
                            {{ __('messages.problems.heading.part3') }}
                        </h2>
                        <p class="subtext">{{ __('messages.problems.description') }}</p>

                        <div class="sticky-image m-b30">
                            <img src="images/medication/img2.png" alt="Doctor explaining medication" />
                        </div>
                    </div>


                </div>
                <div class="col-lg-6">
                    <div class="media-content">


                        <div class="medication-list">
                            @foreach($medications->where('type', 'Treat') as $medication)
                            <div class="medication-item img-box">
                                <div class="ss-media">
                                    <img src="{{ asset('public/uploads/' . $medication->image) }}" alt="{{ $medication->name }}">
                                </div>
                                <div>
                                    <strong>{{ $medication->name }}</strong>
                                    <p>{{ $medication->description }}</p>
                                </div>
                            </div>
                            @endforeach
                        </div>

                    </div>
                </div>

            </div>
        </div>
    </section>

    <section class="team-section overflow-hidden" id="team">

        <div class="container-fluid">
            <h5>{{ __('messages.team.title') }}</h5>
            <h2>
                {{ __('messages.team.heading.part1') }}
                <span class="highlight">{{ __('messages.team.heading.part2') }}</span>
                {{ __('messages.team.heading.part3') }}
            </h2>

            <div class="doctorbox expertSwiper overflow-hidden position-relative">
                <div class="swiper-wrapper position-relative">
                    @foreach($doctors as $key => $doctor)
                    <div class="swiper-slide expert-card position-relative" style="padding-bottom: 20px;">
                        <img src="{{ asset('public/doctorslist/'.$doctor->profilePath) }}" alt="{{ $doctor->name }}">
                        <div class="expert-info">
                            <h4>{{ $doctor->name }}</h4>
                            @php
                            $words = explode(' ', $doctor->description);
                            $shortDesc = implode(' ', array_slice($words, 0, 20));
                            @endphp
                            <p>{{ $shortDesc }}
                                <a href="javascript:void(0);"
                                    class="read-more-link text-primary"
                                    style="text-decoration: none !important; color: #1f2125 !important;"
                                    data-desc="{{ $doctor->description }}">
                                    Read more
                                </a>
                            </p>
                        </div>
                    </div>
                    @endforeach
                </div>
            </div>

            <!-- Floating Popup -->
            <div id="popupBox" class="popup-box"></div>


        </div>
    </section>


    <!-- Contact Section -->
    <section class="contact-section overflow-hidden" id="contact_us">
        <div class="container-fluid">
            <div class="contact-header">
                <h5>{{ __('messages.contact.title') }}</h5>
                <h2>
                    {{ __('messages.contact.heading.part1') }}
                    <span class="text-1">{{ __('messages.contact.heading.part2') }}</span>
                    {{ __('messages.contact.heading.part3') }}
                </h2>
            </div>

            <div class="contact-container" id="contact">
                <div class="contact-form">
                    <form id="contactForm">
                        <label for="name">{{ __('messages.name') }}*</label>
                        <input type="text" id="name" name="name" placeholder="{{ __('messages.placeholder_name') }}">
                        <span class="error-message" id="error-name"></span>

                        <label for="email">{{ __('messages.email') }}*</label>
                        <input type="email" id="email" name="email" placeholder="{{ __('messages.placeholder_email') }}">
                        <span class="error-message" id="error-email"></span>

                        <label for="subject">{{ __('messages.subject') }}*</label>
                        <input type="text" id="subject" name="subject" placeholder="{{ __('messages.placeholder_subject') }}">
                        <span class="error-message" id="error-subject"></span>

                        <label for="message">{{ __('messages.message') }}*</label>
                        <textarea id="message" name="message" placeholder="{{ __('messages.placeholder_message') }}"></textarea>
                        <span class="error-message" id="error-message"></span>

                        <button type="submit">{{ __('messages.send') }}</button>
                    </form>
                    <div id="formResponse"></div>
                </div>

                <div class="contact-image">
                    <img src="images/form-sec/img1.png" alt="Doctor" />
                </div>
            </div>


        </div>
    </section>



    <!-- Footer -->
    <footer class="footer overflow-hidden">
        <div class="container-fluid">
            <div class="footer-content">
                <div class="row">
                    <div class="col-lg-6 col-sm-6 col-12">
                        <div class="footer-col logo-col">
                            <h3 class="footer-logo"><img src="images/footer/footer_logo.svg" alt="/" /></h3>
                            <p>{{ __('messages.footer.description') }}</p>
                            <div class="social-icons">
                                <!--<a href="javascript:void(0);"><i class="fab fa-facebook-f"></i></a>-->
                                <!--<a href="javascript:void(0);"><i class="fab fa-twitter"></i></a>-->
                                <a href=" https://www.linkedin.com/company/quickmedswitzerland/" target="_blank"><i class="fab fa-linkedin"></i></a>
                                <!--<a href="javascript:void(0);"><i class="fab fa-instagram"></i></a>-->
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4 col-sm-3 col-6">
                        <div class="footer-col">
                            <h4>{{ __('messages.footer.company_title') }}</h4>
                            <ul>
                                <li><a href="javascript:void(0);">{{ __('messages.footer.links.home') }}</a></li>
                                <li><a href="javascript:void(0);">{{ __('messages.footer.links.about') }}</a></li>
                                <li><a href="javascript:void(0);">{{ __('messages.footer.links.team') }}</a></li>
                            </ul>
                        </div>
                    </div>

                    <div class="col-lg-2 col-sm-3 col-6">
                        <div class="footer-col">
                            <h4>{{ __('messages.footer.coming_soon') }}</h4>
                            <div class="store-badges">
                                <a href="javascript:void(0);"><img src="images/footer/img2.png" alt="App Store" /></a>
                                <a href="javascript:void(0);"><img src="images/footer/img3.png" alt="Google Play" /></a>
                            </div>
                        </div>
                    </div>
                </div>




            </div>

            <div class="footer-bottom">
                <hr />
                <p>{{ __('messages.footer.copyright') }}</p>
            </div>
        </div>
    </footer>


    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const popup = document.getElementById('popupBox');
            let activeLink = null;

            document.querySelectorAll('.read-more-link').forEach(link => {
                link.addEventListener('click', function(e) {
                    e.stopPropagation();

                    const rect = this.getBoundingClientRect();
                    const description = this.getAttribute('data-desc');

                    // Toggle logic
                    if (activeLink === this) {
                        popup.style.display = 'none';
                        activeLink = null;
                        return;
                    }

                    // Set popup content
                    popup.innerHTML = description;

                    // Temporarily show to measure height
                    popup.style.visibility = 'hidden';
                    popup.style.display = 'block';
                    const popupHeight = popup.offsetHeight;
                    popup.style.visibility = '';

                    const viewportHeight = window.innerHeight;
                    const spaceBelow = viewportHeight - rect.bottom;
                    const spaceAbove = rect.top;

                    let top = 0;

                    // Show above if not enough space below
                    if (spaceBelow < popupHeight && spaceAbove > popupHeight) {
                        top = rect.top + window.scrollY - popupHeight - 10; // above
                    } else {
                        top = rect.bottom + window.scrollY + 10; // below
                    }

                    popup.style.top = `${top}px`;
                    popup.style.left = `${rect.left + window.scrollX}px`;
                    popup.style.display = 'block';

                    activeLink = this;
                });
            });

            // Click outside closes popup
            document.addEventListener('click', function() {
                popup.style.display = 'none';
                activeLink = null;
            });
        });
    </script>




    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>

    <script>
        $(document).ready(function() {
            // Live remove error message on input
            $('#contactForm input, #contactForm textarea').on('input', function() {
                const id = $(this).attr('id');
                $('#error-' + id).html('');
            });

            $('#contactForm').on('submit', function(e) {
                e.preventDefault();
                $('.error-message').html('');
                $('#formResponse').html('');

                $.ajax({
                    url: "{{ url('/contact-submit') }}",
                    type: "POST",
                    data: {
                        name: $('#name').val(),
                        email: $('#email').val(),
                        subject: $('#subject').val(),
                        message: $('#message').val(),
                        _token: "{{ csrf_token() }}"
                    },
                    success: function(response) {
                        if (response.status) {
                            toastr.success(
                                "✔️ Thank you for reaching out to us.<br/>We will get back to you shortly.",
                                '', {
                                    closeButton: true,
                                    progressBar: true,
                                    timeOut: 3000,
                                    positionClass: "toast-top-right",
                                    showDuration: 300,
                                    hideDuration: 1000,
                                    extendedTimeOut: 1000,
                                    escapeHtml: false // IMPORTANT: Allows <br/> to render properly
                                }
                            );

                            $('#contactForm')[0].reset();
                        }
                    },

                    error: function(xhr) {
                        if (xhr.status === 422) {
                            const errors = xhr.responseJSON.errors;
                            if (errors.name) $('#error-name').html('Name is required');
                            if (errors.email) $('#error-email').html('Email is required');
                            if (errors.subject) $('#error-subject').html('Subject is required');
                            if (errors.message) $('#error-message').html('Message is required');
                        }
                    }
                });
            });
        });
    </script>



    <!-- Swiper JS -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"
        integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>
    <script src="plugins/bootstrap/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/swiper@10/swiper-bundle.min.js"></script>

    <script>
        var swiper = new Swiper(".mySwiper", {
            slidesPerView: 1,
            spaceBetween: 20,
            loop: true,
            breakpoints: {
                768: {
                    slidesPerView: 2,
                },
                1024: {
                    slidesPerView: 3,
                },
            },
        });
        var swiper = new Swiper(".mySwiper2", {
            slidesPerView: 2.8,
            spaceBetween: 20,
            loop: true,
            breakpoints: {
                768: {
                    slidesPerView: 2,
                },
                1024: {
                    slidesPerView: 2.8,
                },
            },
        });

        var swiper = new Swiper('.problemsSwiper', {
            slidesPerView: '7',
            spaceBetween: 12,
            loop: true,

        });


        var swiper = new Swiper('.expertSwiper', {
            slidesPerView: 4.2,
            spaceBetween: 20,
            freeMode: true,
            breakpoints: {
                576: {
                    slidesPerView: 2.2,
                },
                768: {
                    slidesPerView: 3.2,
                },
                1024: {
                    slidesPerView: 4.2,
                }
            }
        });
    </script>




</body>

</html>