<?php

use Illuminate\Support\Facades\Route;
use Illuminate\Support\Facades\app;
use App\Http\Controllers\DoctorController;
use App\Http\Controllers\PatientsController;

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider and all of them will
| be assigned to the "web" middleware group. Make something great!
|
*/

Route::get('/demo', function () {
    return view('demo');
});


Route::get('/', [DoctorController::class, 'index'])->name('doctor');

Route::get('/doctor', [PatientsController::class, 'index'])->name('patients');


Route::get('lang/{locale}', function ($locale) {
    if (in_array($locale, ['en', 'hi', 'fr'])) {
        session(['locale' => $locale]);
        App::setLocale($locale);
    }
    return redirect()->back();
});


Route::get('lang/{lang}', function ($lang) {
    session(['locale' => $lang]);
    App::setLocale($lang);
    return redirect()->back();
});

use App\Http\Controllers\ContactController;

Route::post('/contact-submit', [ContactController::class, 'submit']);
