<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>">

<head>
    <meta charset="UTF-8">
    <title>QuickMed Header</title>
    <link rel="stylesheet" href="plugins/bootstrap/bootstrap.min.css">
    </link>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@10/swiper-bundle.min.css">
    <link rel="stylesheet" href="assests/style.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Mukta:wght@200;300;400;500;600;700;800&display=swap"
        rel="stylesheet">
</head>

<body>

    <nav class="navbar navbar-expand-lg bg-body-tertiary">
        <div class="container">
            <img src="images/header/logo.svg" alt="Logo" class="logo">

            <div class="collapse navbar-collapse" id="navbarSupportedContent">
                <ul class="navbar-nav me-auto mb-2 mb-lg-0">
                    <li class="nav-item">
                        <a class="nav-link" href="#"><?php echo e(__('messages.nav.home')); ?></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#about_us"><?php echo e(__('messages.nav.about')); ?></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#team"><?php echo e(__('messages.nav.medical')); ?></a>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <?php echo e(__('messages.nav.symptoms')); ?>

                        </a>
                        <ul class="dropdown-menu custom-dropdown">
                            <?php $__currentLoopData = $treatments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $treatment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><a class="dropdown-item" href="#"><?php echo e($treatment->name); ?></a></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </li>
                </ul>

            </div>
            <div class="d-flex">
                <div class="right-section">
                    <div class="nav-buttons d-flex gap-2">
                        <a href="/doctor" class="btn btn-doctors">For Doctors</a>
                        <a href="contact.html" class="btn btn-contact">Contact Us</a>
                    </div>


                    <?php
                    $locale = app()->getLocale();
                    $flag = $locale === 'fr' ? 'img6.png' : 'img5.png';
                    $alt = $locale === 'fr' ? 'French' : 'English';
                    ?>

                    <div class="btn-group">
                        <button type="button" class="btn btn-secondary dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                            <img src="<?php echo e(asset('images/header/' . $flag)); ?>" alt="<?php echo e($alt); ?>" class="language-flag">
                        </button>
                        <ul class="dropdown-menu dropdown-menu-end">
                            <li>
                                <a class="dropdown-item" href="<?php echo e(url('lang/en')); ?>">
                                    <img src="<?php echo e(asset('images/header/img5.png')); ?>" alt="English" class="language-flag"> English
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item" href="<?php echo e(url('lang/fr')); ?>">
                                    <img src="<?php echo e(asset('images/header/img6.png')); ?>" alt="French" class="language-flag"> French
                                </a>
                            </li>
                        </ul>
                    </div>



                </div>
                <button class="navbar-toggler collapsed" type="button" data-bs-toggle="collapse"
                    data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent"
                    aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                    <i class="fa-solid fa-circle-xmark"></i>
                </button>
                <div>
                </div>
    </nav>



    <section class="banner"
        style="background: url(images/banner/img2.png); background-size: cover; background-repeat: no-repeat;">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-xl-7 col-lg-7 col-md-12 mb-4 order-xl-1 order-lg-2 order-2">
                    <div class="content">
                        <h4>
                            <img src="images/header/img2.png"> <?php echo e(__('messages.priority')); ?>

                        </h4>
                        <h1>
                            <?php echo e(__('messages.consult')); ?> <br>
                            <?php echo e(__('messages.anywhere')); ?>

                            <span class="highlight"><?php echo e(__('messages.switzerland')); ?></span>
                        </h1>
                        <p><?php echo e(__('messages.description')); ?></p>
                        <p class="text"><?php echo e(__('messages.download')); ?></p>

                        <div class="app-buttons">
                            <a href="javascript:void(0);">
                                <img src="https://developer.apple.com/assets/elements/badges/download-on-the-app-store.svg" alt="App Store">
                            </a>
                            <a href="javascript:void(0);">
                                <img src="https://upload.wikimedia.org/wikipedia/commons/7/78/Google_Play_Store_badge_EN.svg" alt="Google Play" class="google">
                            </a>
                        </div>
                    </div>

                </div>
                <div class="col-xl-5 col-lg-5 col-md-12 order-xl-1 order-lg-1 order-1">
                    <div class="image ">
                        <img src="images/banner/img1.png" alt="QuickMed Phone">
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="support-section" id="about_us">
        <div class="container-fluid">
            <div class="row " style=" justify-content: space-between;">
                <div class="col-xl-6">
                    <div class="image-wrapper m-b30">
                        <img src="images/about-us/img1.png" alt="Doctor with patient">
                    </div>
                </div>
                <div class="col-xl-6">

                    <div class="text-content">
                        <h5><?php echo e(__('messages.about')); ?></h5>
                        <h2><?php echo e(__('messages.support_heading')); ?> <span class="highlight"><?php echo e(__('messages.support_highlight')); ?></span> <?php echo e(__('messages.support_you')); ?></h2>
                        <ul class="support-list">
                            <li><i class="fa-solid fa-circle-check"></i> <?php echo e(__('messages.support_1')); ?></li>
                            <li><i class="fa-solid fa-circle-check"></i> <?php echo e(__('messages.support_2')); ?></li>
                            <li><i class="fa-solid fa-circle-check"></i> <?php echo e(__('messages.support_3')); ?></li>
                            <li><i class="fa-solid fa-circle-check"></i> <?php echo e(__('messages.support_4')); ?></li>
                            <li><i class="fa-solid fa-circle-check"></i> <?php echo e(__('messages.support_5')); ?></li>
                            <li><i class="fa-solid fa-circle-check"></i> <?php echo e(__('messages.support_6')); ?></li>
                        </ul>
                    </div>

                </div>
            </div>
        </div>
    </section>

    <section class="hours-section overflow-hidden">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-4">
                    <div class="left-content overflow-hidden">
                        <h5>ABOUT US</h5>
                        <h2>Our open <span class="highlight">hours</span> are</h2>
                        <ul class="hours-list">
                            <li><i class="fa-regular fa-calendar"></i> Mondays to Fridays 7am to 10 am and 1pm to 7pm.
                            </li>
                            <li><i class="fa-regular fa-calendar"></i> Sundays 1pm to 7pm.</li>
                            <li><i class="fa-regular fa-circle-xmark"></i> Closed on Saturdays.</li>
                            <li><i class="fa-regular fa-calendar-check"></i> Open on Public Holidays.</li>
                        </ul>
                    </div>
                </div>
                <div class="col-lg-8">
                    <div class="right-content">
                        <div class="swiper mySwiper2 overflow-hidden">
                            <div class="swiper-wrapper">
                                <div class="swiper-slide card">
                                    <img src="images/service/img1.png" alt="Prescriptions">
                                    <p><?php echo e(__('messages.slider.prescriptions')); ?></p>
                                </div>
                                <div class="swiper-slide card">
                                    <img src="images/service/img2.png" alt="Referrals to specialists">
                                    <p><?php echo e(__('messages.slider.specialists')); ?></p>
                                </div>
                                <div class="swiper-slide card">
                                    <img src="images/service/img3.png" alt="Lab referrals">
                                    <p><?php echo e(__('messages.slider.laboratory')); ?></p>
                                </div>
                                <div class="swiper-slide card">
                                    <img src="images/service/img4.png" alt="Prescriptions">
                                    <p><?php echo e(__('messages.slider.prescriptions')); ?></p>
                                </div>
                                <div class="swiper-slide card">
                                    <img src="images/service/img5.png" alt="Referrals to specialists">
                                    <p><?php echo e(__('messages.slider.specialists')); ?></p>
                                </div>
                            </div>

                        </div>
                    </div>
                </div>
            </div>


        </div>
    </section>

    <section class="no-prescribe-section overflow-hidden">
        <div class="container-fluid">
            <div class="row">
                <div class="col-xl-6 col-lg-8 order-xl-1 order-lg-2 order-2">
                    <div class="media-content m-b30">
                        <div class="medication-list">
                            <div class="medication-item">
                                <i class="fa-solid fa-circle-xmark icon blue"></i>
                                <div>
                                    <strong>Barbiturates</strong>
                                    <p>Sedatives used for seizures and sleep disorders (e.g., Phenobarbital).</p>
                                </div>
                            </div>

                            <div class="medication-item">
                                <i class="fa-solid fa-circle-xmark icon dark"></i>
                                <div>
                                    <strong>Narcotics</strong>
                                    <p>Strong painkillers with high addiction risk (e.g., Morphine, Oxycodone).</p>
                                </div>
                            </div>

                            <div class="medication-item">
                                <i class="fa-solid fa-circle-xmark icon green"></i>
                                <div>
                                    <strong>Benzodiazepines</strong>
                                    <p>Anti-anxiety and sedative drugs (e.g., Xanax, Valium).</p>
                                </div>
                            </div>

                            <div class="medication-item">
                                <i class="fa-solid fa-circle-xmark icon dark"></i>
                                <div>
                                    <strong>Immunosuppressants</strong>
                                    <p>Drugs that weaken the immune system, used for organ transplants or autoimmune
                                        diseases.</p>
                                </div>
                            </div>

                            <div class="medication-item">
                                <i class="fa-solid fa-circle-xmark icon blue"></i>
                                <div>
                                    <strong>Subutex</strong>
                                    <p>Unless you have a proven medical condition with medical documentation that can be
                                        provided.
                                    </p>
                                </div>
                            </div>

                            <div class="medication-item">
                                <i class="fa-solid fa-circle-xmark icon green"></i>
                                <div>
                                    <strong>Products containing Marijuana</strong>
                                    <p>Includes CBD with THC and medical cannabis.</p>
                                </div>
                            </div>

                            <div class="medication-item">
                                <i class="fa-solid fa-circle-xmark icon green"></i>
                                <div>
                                    <strong>Products containing Marijuana</strong>
                                    <p>Includes CBD with THC and medical cannabis.</p>
                                </div>
                            </div>

                            <div class="medication-item">
                                <i class="fa-solid fa-circle-xmark icon green"></i>
                                <div>
                                    <strong>Products containing Marijuana</strong>
                                    <p>Includes CBD with THC and medical cannabis.</p>
                                </div>
                            </div>

                            <div class="medication-item">
                                <i class="fa-solid fa-circle-xmark icon green"></i>
                                <div>
                                    <strong>Products containing Marijuana</strong>
                                    <p>Includes CBD with THC and medical cannabis.</p>
                                </div>
                            </div>

                            <div class="medication-item">
                                <i class="fa-solid fa-circle-xmark icon green"></i>
                                <div>
                                    <strong>Products containing Marijuana</strong>
                                    <p>Includes CBD with THC and medical cannabis.</p>
                                </div>
                            </div>

                            <div class="medication-item">
                                <i class="fa-solid fa-circle-xmark icon green"></i>
                                <div>
                                    <strong>Products containing Marijuana</strong>
                                    <p>Includes CBD with THC and medical cannabis.</p>
                                </div>
                            </div>

                            <div class="medication-item">
                                <i class="fa-solid fa-circle-xmark icon green"></i>
                                <div>
                                    <strong>Products containing Marijuana</strong>
                                    <p>Includes CBD with THC and medical cannabis.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="col-xl-6 col-lg-4 order-xl-2 order-lg-1 order-1">
                    <div class="right-content sticky-top">
                        <h5><?php echo e(__('messages.medications_title')); ?></h5>
                        <h2><?php echo e(__('messages.medications_heading')); ?> <span class="highlight"><?php echo e(__('messages.medications_highlight')); ?></span></h2>
                        <p class="subtext"><?php echo e(__('messages.medications_subtext')); ?></p>
                        <div class="sticky-image m-b30">
                            <img src="images/medication/img1.png" alt="Doctor explaining medication" />
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="problems-section overflow-hidden">
        <div class="container-fluid">
            <h5><?php echo e(__('messages.services.title')); ?></h5>
            <h2><?php echo e(__('messages.services.subtitle.part1')); ?> <span class="highlight"><?php echo e(__('messages.services.subtitle.highlight')); ?></span> <?php echo e(__('messages.services.subtitle.part2')); ?></h2>


            <div class="swiper problemsSwiper overflow-visible">
                <div class="swiper-wrapper">
                    <div class="swiper-slide problem-chip">Coughs & colds</div>
                    <div class="swiper-slide problem-chip">Earaches and infections</div>
                    <div class="swiper-slide problem-chip">Flu-like symptoms</div>
                    <div class="swiper-slide problem-chip">High blood pressure</div>
                    <div class="swiper-slide problem-chip">Itchy or sore throat</div>
                    <div class="swiper-slide problem-chip">Muscle sprains & strains</div>
                    <div class="swiper-slide problem-chip">Pinworms</div>
                    <div class="swiper-slide problem-chip">Poison ivy, oak or sumac</div>
                    <div class="swiper-slide problem-chip">Respiratory infections</div>
                    <div class="swiper-slide problem-chip">Sinus infections</div>
                    <div class="swiper-slide problem-chip">Skin rashes</div>
                    <div class="swiper-slide problem-chip">Coughs & colds</div>
                    <div class="swiper-slide problem-chip">Earaches and infections</div>
                    <div class="swiper-slide problem-chip">Flu-like symptoms</div>
                    <div class="swiper-slide problem-chip">High blood pressure</div>
                    <div class="swiper-slide problem-chip">Itchy or sore throat</div>
                    <div class="swiper-slide problem-chip">Muscle sprains & strains</div>
                    <div class="swiper-slide problem-chip">Pinworms</div>
                    <div class="swiper-slide problem-chip">Poison ivy, oak or sumac</div>
                    <div class="swiper-slide problem-chip">Respiratory infections</div>
                    <div class="swiper-slide problem-chip">Sinus infections</div>
                    <div class="swiper-slide problem-chip">Skin rashes</div>
                </div>
            </div>
        </div>
    </section>

    <section class="no-prescribe-section overflow-hidden">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-6">
                    <div class="right-content sticky-top">
                        <h5><?php echo e(__('messages.medications.title')); ?></h5>
                        <h2><?php echo e(__('messages.medications.heading.part1')); ?> <span class="highlight"><?php echo e(__('messages.medications.heading.part2')); ?></span></h2>
                        <p class="subtext">
                            <?php echo e(__('messages.medications.description')); ?>

                        </p>
                        <div class="sticky-image m-b30">
                            <img src="images/medication/img2.png" alt="Doctor explaining medication" />
                        </div>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="media-content">


                        <div class="medication-list">
                            <div class="medication-item img-box">
                                <div class="ss-media">
                                    <img src="images/icon/img1.png" alt="/">
                                </div>

                                <div>
                                    <strong>Barbiturates</strong>
                                    <p>Sedatives used for seizures and sleep disorders (e.g., Phenobarbital).</p>
                                </div>
                            </div>

                            <div class="medication-item img-box">
                                <div class="ss-media">
                                    <img src="images/icon/img2.png" alt="/">
                                </div>

                                <div>
                                    <strong>Narcotics</strong>
                                    <p>Strong painkillers with high addiction risk (e.g., Morphine, Oxycodone).</p>
                                </div>
                            </div>

                            <div class="medication-item img-box">
                                <div class="ss-media">
                                    <img src="images/icon/img3.png" alt="/">
                                </div>

                                <div>
                                    <strong>Benzodiazepines</strong>
                                    <p>Anti-anxiety and sedative drugs (e.g., Xanax, Valium).</p>
                                </div>
                            </div>

                            <div class="medication-item img-box">
                                <div class="ss-media">
                                    <img src="images/icon/img4.png" alt="/">
                                </div>

                                <div>
                                    <strong>Immunosuppressants</strong>
                                    <p>Drugs that weaken the immune system, used for organ transplants or autoimmune
                                        diseases.</p>
                                </div>
                            </div>

                            <div class="medication-item img-box">
                                <div class="ss-media">
                                    <img src="images/icon/img5.png" alt="/">
                                </div>

                                <div>
                                    <strong>Subutex</strong>
                                    <p>Unless you have a proven medical condition with medical documentation that can be
                                        provided.
                                    </p>
                                </div>
                            </div>

                            <div class="medication-item img-box">
                                <div class="ss-media">
                                    <img src="images/icon/img6.png" alt="/">
                                </div>
                                <div>
                                    <strong>Products containing Marijuana</strong>
                                    <p>Includes CBD with THC and medical cannabis.</p>
                                </div>
                            </div>
                            <div class="medication-item img-box">
                                <div class="ss-media">
                                    <img src="images/icon/img1.png" alt="/">
                                </div>
                                <div>
                                    <strong>Products containing Marijuana</strong>
                                    <p>Includes CBD with THC and medical cannabis.</p>
                                </div>
                            </div>
                            <div class="medication-item img-box">
                                <div class="ss-media">
                                    <img src="images/icon/img2.png" alt="/">
                                </div>
                                <div>
                                    <strong>Products containing Marijuana</strong>
                                    <p>Includes CBD with THC and medical cannabis.</p>
                                </div>
                            </div>
                            <div class="medication-item img-box">
                                <div class="ss-media">
                                    <img src="images/icon/img3.png" alt="/">
                                </div>
                                <div>
                                    <strong>Products containing Marijuana</strong>
                                    <p>Includes CBD with THC and medical cannabis.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

            </div>
        </div>
    </section>

    <section class="team-section overflow-hidden" id="team">
        <div class="container-fluid">
            <h5><?php echo e(__('messages.team.title')); ?></h5>
            <h2>
                <?php echo e(__('messages.team.heading.part1')); ?>

                <span class="highlight"><?php echo e(__('messages.team.heading.part2')); ?></span>
                <?php echo e(__('messages.team.heading.part3')); ?>

            </h2>

            <div class="swiper expertSwiper overflow-hidden">
                <div class="swiper-wrapper">

                    <!-- Card 1 -->
                    <div class="swiper-slide expert-card">
                        <img src="images/our-team/img1.jpeg" alt="Dr. Abdel Boudemagh" />
                        <div class="expert-info">
                            <h4>Dr. Abdel Boudemagh</h4>
                            <p>Specialist in neurosurgery with 14 years of experience in general internal medicine.
                                Former
                                medical director at Medgate.</p>
                        </div>
                    </div>

                    <!-- Card 2 -->
                    <div class="swiper-slide expert-card">
                        <img src="images/our-team/img2.jpeg" alt="Dr. Mohammad Kassar" />
                        <div class="expert-info">
                            <h4>Dr. Mohammad Kassar</h4>
                            <p>Specialist in interventional cardiology with expertise in advanced cardiac imaging and
                                structural heart disease intervention.</p>
                        </div>
                    </div>

                    <!-- Card 3 -->
                    <div class="swiper-slide expert-card">
                        <img src="images/our-team/img3.jpeg" alt="Dr. Etienne Mauron" />
                        <div class="expert-info">
                            <h4>Dr. Etienne Mauron</h4>
                            <p>Specialist in internal medicine with emergency care experience. Fluent in EN, FR, DE, PT.
                            </p>
                        </div>
                    </div>

                    <!-- Card 4 -->
                    <div class="swiper-slide expert-card">
                        <img src="images/our-team/img4.jpeg" alt="Dr. Mariam Nasr" />
                        <div class="expert-info">
                            <h4>Dr. Mariam Nasr</h4>
                            <p>GP with experience in UK & Switzerland, 5 years in telemedicine. Speaks EN, DE, AR.</p>
                        </div>
                    </div>

                    <!-- Card 5 -->
                    <div class="swiper-slide expert-card">
                        <img src="images/our-team/img5.jpeg" alt="Dr. Fat..." />
                        <div class="expert-info">
                            <h4>Dr. Fat...</h4>
                            <p>Specialist in anesthesiology since 2010. Works in Vaud. Speaks multiple languages.</p>
                        </div>
                    </div>

                    <!-- Card 6 -->
                    <div class="swiper-slide expert-card">
                        <img src="images/our-team/img6.jpeg" alt="Dr. Abdel Boudemagh" />
                        <div class="expert-info">
                            <h4>Dr. Abdel Boudemagh</h4>
                            <p>Specialist in neurosurgery with 14 years of experience in general internal medicine.
                                Former
                                medical director at Medgate.</p>
                        </div>
                    </div>

                    <!-- Card 7 -->
                    <div class="swiper-slide expert-card">
                        <img src="images/our-team/img7.jpeg" alt="Dr. Mohammad Kassar" />
                        <div class="expert-info">
                            <h4>Dr. Mohammad Kassar</h4>
                            <p>Specialist in interventional cardiology with expertise in advanced cardiac imaging and
                                structural heart disease intervention.</p>
                        </div>
                    </div>

                    <!-- Card 8 -->
                    <div class="swiper-slide expert-card">
                        <img src="images/our-team/img8.jpeg" alt="Dr. Etienne Mauron" />
                        <div class="expert-info">
                            <h4>Dr. Etienne Mauron</h4>
                            <p>Specialist in internal medicine with emergency care experience. Fluent in EN, FR, DE, PT.
                            </p>
                        </div>
                    </div>

                    <!-- Card 9 -->
                    <div class="swiper-slide expert-card">
                        <img src="images/our-team/img9.jpeg" alt="Dr. Mariam Nasr" />
                        <div class="expert-info">
                            <h4>Dr. Mariam Nasr</h4>
                            <p>GP with experience in UK & Switzerland, 5 years in telemedicine. Speaks EN, DE, AR.</p>
                        </div>
                    </div>

                    <!-- Card 10 -->
                    <div class="swiper-slide expert-card">
                        <img src="images/our-team/img10.jpeg" alt="Dr. Fat..." />
                        <div class="expert-info">
                            <h4>Dr. Fat...</h4>
                            <p>Specialist in anesthesiology since 2010. Works in Vaud. Speaks multiple languages.</p>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </section>


    <!-- Contact Section -->
    <section class="contact-section overflow-hidden" id="contact_us">
        <div class="container-fluid">
            <div class="contact-header">
                <h5><?php echo e(__('messages.contact.title')); ?></h5>
                <h2>
                    <?php echo e(__('messages.contact.heading.part1')); ?>

                    <span class="text-1"><?php echo e(__('messages.contact.heading.part2')); ?></span>
                    <?php echo e(__('messages.contact.heading.part3')); ?>

                </h2>
            </div>

            <div class="contact-container">
                <div class="contact-form">
                    <form>
                        <label for="name">Name*</label>
                        <input type="text" id="name" placeholder="Enter name" required />

                        <label for="email">Email*</label>
                        <input type="email" id="email" placeholder="Enter email" required />

                        <label for="subject">Subject*</label>
                        <input type="text" id="subject" placeholder="Type here..." required />

                        <label for="message">Message*</label>
                        <textarea id="message" rows="4" placeholder="Type here..." required></textarea>

                        <button type="submit">Send</button>
                    </form>
                </div>

                <div class="contact-image">
                    <img src="images/form-sec/img1.png" alt="Doctor" />
                </div>
            </div>
        </div>
    </section>



    <!-- Footer -->
    <footer class="footer overflow-hidden">
        <div class="container-fluid">
            <div class="footer-content">
                <div class="row">
                    <div class="col-lg-6 col-sm-6 col-12">
                        <div class="footer-col logo-col">
                            <h3 class="footer-logo"><img src="images/footer/footer_logo.svg" alt="/" /></h3>
                            <p><?php echo e(__('messages.footer.description')); ?></p>
                            <div class="social-icons">
                                <a href="javascript:void(0);"><i class="fab fa-facebook-f"></i></a>
                                <a href="javascript:void(0);"><i class="fab fa-twitter"></i></a>
                                <a href="javascript:void(0);"><i class="fab fa-linkedin"></i></a>
                                <a href="javascript:void(0);"><i class="fab fa-instagram"></i></a>
                            </div>
                        </div>
                    </div>

                    <div class="col-lg-4 col-sm-3 col-6">
                        <div class="footer-col">
                            <h4><?php echo e(__('messages.footer.company_title')); ?></h4>
                            <ul>
                                <li><a href="javascript:void(0);"><?php echo e(__('messages.footer.links.home')); ?></a></li>
                                <li><a href="javascript:void(0);"><?php echo e(__('messages.footer.links.about')); ?></a></li>
                                <li><a href="javascript:void(0);"><?php echo e(__('messages.footer.links.team')); ?></a></li>
                            </ul>
                        </div>
                    </div>

                    <div class="col-lg-2 col-sm-3 col-6">
                        <div class="footer-col">
                            <h4><?php echo e(__('messages.footer.coming_soon')); ?></h4>
                            <div class="store-badges">
                                <a href="javascript:void(0);"><img src="images/footer/img2.png" alt="App Store" /></a>
                                <a href="javascript:void(0);"><img src="images/footer/img3.png" alt="Google Play" /></a>
                            </div>
                        </div>
                    </div>
                </div>




            </div>

            <div class="footer-bottom">
                <hr />
                <p><?php echo e(__('messages.footer.copyright')); ?></p>
            </div>
        </div>
    </footer>








    <!-- Swiper JS -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"
        integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>
    <script src="plugins/bootstrap/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/swiper@10/swiper-bundle.min.js"></script>

    <script>
        var swiper = new Swiper(".mySwiper", {
            slidesPerView: 1,
            spaceBetween: 20,
            loop: true,
            breakpoints: {
                768: {
                    slidesPerView: 2,
                },
                1024: {
                    slidesPerView: 3,
                },
            },
        });
        var swiper = new Swiper(".mySwiper2", {
            slidesPerView: 2.8,
            spaceBetween: 20,
            loop: true,
            breakpoints: {
                768: {
                    slidesPerView: 2,
                },
                1024: {
                    slidesPerView: 2.8,
                },
            },
        });

        var swiper = new Swiper('.problemsSwiper', {
            slidesPerView: '7',
            spaceBetween: 12,
            loop: true,

        });


        var swiper = new Swiper('.expertSwiper', {
            slidesPerView: 4.2,
            spaceBetween: 20,
            freeMode: true,
            breakpoints: {
                576: {
                    slidesPerView: 2.2,
                },
                768: {
                    slidesPerView: 3.2,
                },
                1024: {
                    slidesPerView: 4.2,
                }
            }
        });
    </script>




</body>

</html><?php /**PATH C:\xampp\htdocs\quickmed\resources\views/index.blade.php ENDPATH**/ ?>