<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>">

<head>
    <meta charset="UTF-8">
    <title>QuickMed Header</title>

    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">

    <link rel="stylesheet" href="plugins/bootstrap/bootstrap.min.css">
    </link>
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/swiper@10/swiper-bundle.min.css">
    <link rel="stylesheet" href="assests/style.css">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link rel="preconnect" href="https://fonts.gstatic.com" crossorigin>
    <link href="https://fonts.googleapis.com/css2?family=Mukta:wght@200;300;400;500;600;700;800&display=swap"
        rel="stylesheet">
          <link rel="shortcut icon" href="public/Fav-icon.png" type="image/x-icon">

</head>

<body>

    <nav class="navbar navbar-expand-lg bg-body-tertiary">
        <div class="container">
            <img src="images/header/logo.svg" alt="Logo" class="logo">

            <div class="collapse navbar-collapse" id="navbarSupportedContent">


                <ul class="topbar me-auto mb-2 mb-lg-0">
                    <li class="nav-item">
                        <a class="nav-link" href="#"><?php echo e(__('patients.nav.home')); ?></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#about_us"><?php echo e(__('patients.nav.about')); ?></a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="#team"><?php echo e(__('patients.nav.medical')); ?></a>
                    </li>
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" role="button" data-bs-toggle="dropdown" aria-expanded="false">
                            <?php echo e(__('patients.nav.symptoms')); ?>

                        </a>
                        <ul class="dropdown-menu custom-dropdown">
                            <?php $__currentLoopData = $treatments; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $treatment): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><a class="dropdown-item" href="#"><?php echo e($treatment->name); ?></a></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </li>
                </ul>

            </div>
            <div class="d-flex">
                <div class="right-section">
                    <div class="nav-buttons d-flex gap-2">
                        <a href="<?php echo e(route('doctor')); ?>" class="btn btn-doctors"><?php echo e(__('patients.for_doctors')); ?></a>
                        <a href="#contact" class="btn btn-contact"><?php echo e(__('patients.contact_us')); ?></a>

                    </div>
                    <?php
                    $locale = app()->getLocale();
                    $flag = $locale === 'fr' ? 'img6.png' : 'img5.png';
                    $alt = $locale === 'fr' ? 'French' : 'English';
                    ?>

                    <div class="btn-group">
                        <button type="button" class="btn btn-secondary dropdown-toggle" data-bs-toggle="dropdown" aria-expanded="false">
                            <img src="<?php echo e(asset('images/header/' . $flag)); ?>" alt="<?php echo e($alt); ?>" class="language-flag">
                        </button>
                        <ul class="dropdown-menu dropdown-menu-end">
                            <li>
                                <a class="dropdown-item" href="<?php echo e(url('lang/en')); ?>">
                                    <img src="<?php echo e(asset('images/header/img5.png')); ?>" alt="English" class="language-flag"> English
                                </a>
                            </li>
                            <li>
                                <a class="dropdown-item" href="<?php echo e(url('lang/fr')); ?>">
                                    <img src="<?php echo e(asset('images/header/img6.png')); ?>" alt="French" class="language-flag"> French
                                </a>
                            </li>
                        </ul>
                    </div>



                </div>
                <button class="navbar-toggler collapsed" type="button" data-bs-toggle="collapse"
                    data-bs-target="#navbarSupportedContent" aria-controls="navbarSupportedContent"
                    aria-expanded="false" aria-label="Toggle navigation">
                    <span class="navbar-toggler-icon"></span>
                    <i class="fa-solid fa-circle-xmark"></i>
                </button>
                <div>
                </div>
    </nav>




    <section class="banner"
        style="background: url(images/banner/img2.png); background-size: cover; background-repeat: no-repeat;">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-xl-7 col-lg-7 col-md-12 mb-4 order-xl-1 order-lg-2 order-2">

                    <div class="content">
                        <h4><img src="images/header/img2.png"> <?php echo e(__('patients.tagline')); ?></h4>
                        <h1>
                            <?php echo e(__('patients.consult_line1')); ?> <br>
                            <span class="highlight"><?php echo e(__('patients.consult_line2')); ?></span>
                        </h1>
                        <p><?php echo e(__('patients.description1')); ?></p>
                        <p class="text"><?php echo e(__('patients.description2')); ?></p>
                        <div class="app-buttons">
                            <a href="javascript:void(0);">
                                <img src="https://developer.apple.com/assets/elements/badges/download-on-the-app-store.svg" alt="App Store">
                            </a>
                            <a href="javascript:void(0);">
                                <img src="https://upload.wikimedia.org/wikipedia/commons/7/78/Google_Play_Store_badge_EN.svg" alt="Google Play" class="google">
                            </a>
                        </div>
                    </div>

                </div>
                <div class="col-xl-5 col-lg-5 col-md-12 order-xl-1 order-lg-1 order-1">
                    <div class="image">
                        <img src="images/banner/img1.png" alt="QuickMed Phone">
                    </div>
                </div>
            </div>
        </div>
    </section>

    <section class="support-section" id="about_us">
        <div class="container-fluid">
            <div class="row " style=" justify-content: space-between;">
                <div class="col-xl-6">
                    <div class="image-wrapper m-b30 ">
                        <img src="images/about-us/about_us_doctor.png" alt="Doctor with patient">
                    </div>
                </div>
                <div class="col-xl-6">
                    <div class="text-content">
                        <h5><?php echo e(__('patients.about.title')); ?></h5>
                        <h2><?php echo __('patients.about.heading'); ?></h2>
                        <ul class="support-list">
                            <?php $__currentLoopData = __('patients.about.list'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <li><i class="fa-solid fa-circle-check"></i> <?php echo e($item); ?></li>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </ul>
                    </div>

                </div>
            </div>
        </div>
    </section>

    <section class="hours-section ">
        <div class="container">
            <div class="row">
                <div class="col-lg-12">
                    <div class="left-content">
                        <h5 style="font-size: 18px;"><?php echo e(__('patients.offer.title')); ?></h5>
                        <h2 style="font-size: 36px;"><?php echo __('patients.offer.heading'); ?></h2>

                        <p style="font-size: 17px;">
                            <?php echo e(__('patients.offer.description')); ?>

                        </p>

                        <div class="bg-white p-4 p-md-5 rounded-4 shadow-sm mt-4">
                            <ul class="list-unstyled">
                                <?php $__currentLoopData = __('patients.offer.list'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <li class="mb-3">
                                    <div class="d-flex align-items-start gap-3">
                                        <i class="fa-solid fa-circle-check text-info mt-1" style="font-size: 16px;"></i>
                                        <span><?php echo e($item); ?></span>
                                    </div>
                                </li>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </ul>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </section>


    <section class="no-prescribe-section overflow-hidden">
        <div class="container-fluid">
            <div class="row">
                <div class="col-xl-6 col-lg-8 order-xl-1 order-lg-2 order-2">
                    <div class="media-content m-b30">

                        <div class="medication-list">
                            <?php $__currentLoopData = $medications->where('type', 'Prescribe'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $medication): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="medication-item img-box">
                                <div class="ss-media">
                                    <img src="<?php echo e(asset('public/uploads/' . $medication->image)); ?>" alt="<?php echo e($medication->name); ?>">
                                </div>
                                <div>
                                    <strong><?php echo e($medication->name); ?></strong>
                                    <p><?php echo e($medication->description); ?></p>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>

                    </div>
                </div>
                <div class="col-xl-6 col-lg-4 order-xl-2 order-lg-1 order-1">
                    <div class="right-content sticky-top">
                        <h5><?php echo e(__('patients.medications.title')); ?></h5>
                        <h2><?php echo __('patients.medications.heading'); ?></h2>
                        <p class="subtext">
                            <?php echo e(__('patients.medications.description')); ?>

                        </p>
                        <div class="sticky-image m-b30">
                            <img src="<?php echo e(asset('images/medication/img1.png')); ?>" alt="<?php echo e(__('patients.medications.image_alt')); ?>" />
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </section>

    <section class="problems-section overflow-hidden">
        <div class="container-fluid">
            <h5><?php echo e(__('patients.services.title')); ?></h5>
            <h2><?php echo __('patients.services.heading'); ?></h2>


            <div class="swiper problemsSwiper overflow-visible">
                <div class="swiper-wrapper">
                    <div class="swiper-slide problem-chip"><?php echo e(__('messages.coughs_colds')); ?></div>
                    <div class="swiper-slide problem-chip"><?php echo e(__('messages.earaches')); ?></div>
                    <div class="swiper-slide problem-chip"><?php echo e(__('messages.flu')); ?></div>
                    <div class="swiper-slide problem-chip"><?php echo e(__('messages.bp')); ?></div>
                    <div class="swiper-slide problem-chip"><?php echo e(__('messages.sore_throat')); ?></div>
                    <div class="swiper-slide problem-chip"><?php echo e(__('messages.muscle')); ?></div>
                    <div class="swiper-slide problem-chip"><?php echo e(__('messages.pinworms')); ?></div>
                    <div class="swiper-slide problem-chip"><?php echo e(__('messages.poison_ivy')); ?></div>
                    <div class="swiper-slide problem-chip"><?php echo e(__('messages.respiratory')); ?></div>
                    <div class="swiper-slide problem-chip"><?php echo e(__('messages.sinus')); ?></div>
                    <div class="swiper-slide problem-chip"><?php echo e(__('messages.rashes')); ?></div>
                </div>
            </div>
        </div>
    </section>

    <section class="no-prescribe-section overflow-hidden">
        <div class="container-fluid">
            <div class="row">
                <div class="col-lg-6">
                    <div class="right-content sticky-top">
                        <h5><?php echo e(__('messages.problems.title')); ?></h5>
                        <h2>
                            <?php echo e(__('messages.problems.heading.part1')); ?>

                            <span class="highlight"><?php echo e(__('messages.problems.heading.part2')); ?></span>
                            <?php echo e(__('messages.problems.heading.part3')); ?>

                        </h2>
                        <p class="subtext"><?php echo e(__('messages.problems.description')); ?></p>

                        <div class="sticky-image m-b30">
                            <img src="images/medication/img2.png" alt="Doctor explaining medication" />
                        </div>
                    </div>

                </div>
                <div class="col-lg-6">
                    <div class="media-content">


                        <div class="medication-list">
                            <?php $__currentLoopData = $medications->where('type', 'Treat'); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $medication): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <div class="medication-item img-box">
                                <div class="ss-media">
                                    <img src="<?php echo e(asset('public/uploads/' . $medication->image)); ?>" alt="<?php echo e($medication->name); ?>">
                                </div>
                                <div>
                                    <strong><?php echo e($medication->name); ?></strong>
                                    <p><?php echo e($medication->description); ?></p>
                                </div>
                            </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </div>

                    </div>
                </div>

            </div>
        </div>
    </section>

    <section class="team-section overflow-hidden" id="team">
        <div class="container-fluid">
            <h5><?php echo e(__('patients.team.title')); ?></h5>
            <h2><?php echo __('patients.team.heading'); ?></h2>

            <div class="doctorbox expertSwiper overflow-hidden position-relative">
                <div class="swiper-wrapper position-relative">
                    <?php $__currentLoopData = $doctors; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $key => $doctor): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <div class="swiper-slide expert-card position-relative" style="padding-bottom: 20px;">
                        <img src="<?php echo e(asset('public/doctorslist/'.$doctor->profilePath)); ?>" alt="<?php echo e($doctor->name); ?>">
                        <div class="expert-info">
                            <h4><?php echo e($doctor->name); ?></h4>
                            <?php
                            $words = explode(' ', $doctor->description);
                            $shortDesc = implode(' ', array_slice($words, 0, 20));
                            ?>
                            <p><?php echo e($shortDesc); ?>

                                <a href="javascript:void(0);"
                                    class="read-more-link text-primary"
                                    style="text-decoration: none !important; color: #1f2125 !important;"
                                    data-desc="<?php echo e($doctor->description); ?>">
                                    Read more
                                </a>
                            </p>
                        </div>
                    </div>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </div>
            </div>

            <!-- Floating Popup -->
            <div id="popupBox" class="popup-box"></div>



        </div>
    </section>


    <!-- Contact Section -->
    <section class="contact-section overflow-hidden" id="contact_us">
        <div class="container-fluid">
            <div class="contact-header">
                <h5><?php echo e(__('patients.contact.title')); ?></h5>
                <h2><?php echo __('patients.contact.heading'); ?></h2>

            </div>

            <div class="contact-container" id="contact">
                <div class="contact-form">
                    <form id="contactForm">
                        <label for="name"><?php echo e(__('patients.name')); ?>*</label>
                        <input type="text" id="name" name="name" placeholder="<?php echo e(__('patients.placeholder_name')); ?>" required>

                        <label for="email"><?php echo e(__('patients.email')); ?>*</label>
                        <input type="email" id="email" name="email" placeholder="<?php echo e(__('patients.placeholder_email')); ?>" required>

                        <label for="subject"><?php echo e(__('patients.subject')); ?>*</label>
                        <input type="text" id="subject" name="subject" placeholder="<?php echo e(__('patients.placeholder_subject')); ?>" required>

                        <label for="message"><?php echo e(__('patients.message')); ?>*</label>
                        <textarea id="message" name="message" rows="4" placeholder="<?php echo e(__('patients.placeholder_message')); ?>" required></textarea>

                        <button type="submit"><?php echo e(__('patients.send')); ?></button>
                    </form>
                    <div id="formResponse"></div>
                </div>

                <div class="contact-image">
                    <img src="images/form-sec/img1.png" alt="Doctor" />
                </div>
            </div>
        </div>
    </section>



    <!-- Footer -->
    <footer class="footer overflow-hidden">
        <div class="container-fluid">
            <div class="footer-content">
                <div class="row">
                    <div class="col-lg-6 col-sm-6 col-12">
                        <div class="footer-col logo-col">
                            <h3 class="footer-logo"><img src="images/footer/footer_logo.svg" alt="/"></h3>
                            <p><?php echo e(__('patients.footer.description')); ?></p>
                            <div class="social-icons">
                                <a href="javascript:void(0);"><i class="fab fa-facebook-f"></i></a>
                                <a href="javascript:void(0);"><i class="fab fa-twitter"></i></a>
                                <a href="javascript:void(0);"><i class="fab fa-linkedin"></i></a>
                                <a href="javascript:void(0);"><i class="fab fa-instagram"></i></a>
                            </div>
                        </div>

                    </div>
                    <div class="col-lg-4 col-sm-3 col-6">
                        <div class="footer-col">
                            <h4><?php echo e(__('patients.footer.company_title')); ?></h4>
                            <ul>
                                <li><a href="javascript:void(0);"><?php echo e(__('patients.footer.links.home')); ?></a></li>
                                <li><a href="javascript:void(0);"><?php echo e(__('patients.footer.links.about')); ?></a></li>
                                <li><a href="javascript:void(0);"><?php echo e(__('patients.footer.links.team')); ?></a></li>
                            </ul>
                        </div>

                    </div>
                    <div class="col-lg-2 col-sm-3 col-6">
                        <div class="footer-col">
                            <h4><?php echo e(__('patients.footer.coming_soon')); ?></h4>
                            <div class="store-badges">
                                <a href="javascript:void(0);"><img src="images/footer/img2.png" alt="App Store"></a>
                                <a href="javascript:void(0);"><img src="images/footer/img3.png" alt="Google Play"></a>
                            </div>
                        </div>
                    </div>
                </div>



            </div>

            <div class="footer-bottom">
                <hr />
                <p><?php echo e(__('patients.footer.copyright')); ?></p>
            </div>
        </div>
    </footer>

    <script>
        document.addEventListener('DOMContentLoaded', function() {
            const popup = document.getElementById('popupBox');
            let activeLink = null;

            document.querySelectorAll('.read-more-link').forEach(link => {
                link.addEventListener('click', function(e) {
                    e.stopPropagation();

                    const rect = this.getBoundingClientRect();
                    const description = this.getAttribute('data-desc');

                    // Toggle logic
                    if (activeLink === this) {
                        popup.style.display = 'none';
                        activeLink = null;
                        return;
                    }

                    // Set popup content
                    popup.innerHTML = description;

                    // Temporarily show to measure height
                    popup.style.visibility = 'hidden';
                    popup.style.display = 'block';
                    const popupHeight = popup.offsetHeight;
                    popup.style.visibility = '';

                    const viewportHeight = window.innerHeight;
                    const spaceBelow = viewportHeight - rect.bottom;
                    const spaceAbove = rect.top;

                    let top = 0;

                    // Show above if not enough space below
                    if (spaceBelow < popupHeight && spaceAbove > popupHeight) {
                        top = rect.top + window.scrollY - popupHeight - 10; // above
                    } else {
                        top = rect.bottom + window.scrollY + 10; // below
                    }

                    popup.style.top = `${top}px`;
                    popup.style.left = `${rect.left + window.scrollX}px`;
                    popup.style.display = 'block';

                    activeLink = this;
                });
            });

            // Click outside closes popup
            document.addEventListener('click', function() {
                popup.style.display = 'none';
                activeLink = null;
            });
        });
    </script>






    <script src="https://cdnjs.cloudflare.com/ajax/libs/jquery/3.6.0/jquery.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/toastr.js/latest/toastr.min.js"></script>

    <script>
        $(document).ready(function() {
            // Live remove error message on input
            $('#contactForm input, #contactForm textarea').on('input', function() {
                const id = $(this).attr('id');
                $('#error-' + id).html('');
            });

            $('#contactForm').on('submit', function(e) {
                e.preventDefault();
                $('.error-message').html('');
                $('#formResponse').html('');

                $.ajax({
                    url: "<?php echo e(url('/contact-submit')); ?>",
                    type: "POST",
                    data: {
                        name: $('#name').val(),
                        email: $('#email').val(),
                        subject: $('#subject').val(),
                        message: $('#message').val(),
                        _token: "<?php echo e(csrf_token()); ?>"
                    },
                    success: function(response) {
                        if (response.status) {
                            toastr.success(
                                "✔️ Thank you for reaching out to us.<br/>We will get back to you shortly.",
                                '', {
                                    closeButton: true,
                                    progressBar: true,
                                    timeOut: 3000,
                                    positionClass: "toast-top-right",
                                    showDuration: 300,
                                    hideDuration: 1000,
                                    extendedTimeOut: 1000,
                                    escapeHtml: false // IMPORTANT: Allows <br/> to render properly
                                }
                            );

                            $('#contactForm')[0].reset();
                        }
                    },

                    error: function(xhr) {
                        if (xhr.status === 422) {
                            const errors = xhr.responseJSON.errors;
                            if (errors.name) $('#error-name').html('Name is required');
                            if (errors.email) $('#error-email').html('Email is required');
                            if (errors.subject) $('#error-subject').html('Subject is required');
                            if (errors.message) $('#error-message').html('Message is required');
                        }
                    }
                });
            });
        });
    </script>







    <!-- Swiper JS -->
    <script src="https://code.jquery.com/jquery-3.7.1.min.js"
        integrity="sha256-/JqT3SQfawRcv/BIHPThkBvs0OEvtFFmqPF/lYI/Cxo=" crossorigin="anonymous"></script>
    <script src="plugins/bootstrap/bootstrap.bundle.min.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/swiper@10/swiper-bundle.min.js"></script>

    <script>
        var swiper = new Swiper(".mySwiper", {
            slidesPerView: 1,
            spaceBetween: 20,
            loop: true,
            breakpoints: {
                768: {
                    slidesPerView: 2,
                },
                1024: {
                    slidesPerView: 3,
                },
            },
        });
        var swiper = new Swiper(".mySwiper2", {
            slidesPerView: 2.8,
            spaceBetween: 20,
            loop: true,
            breakpoints: {
                768: {
                    slidesPerView: 2,
                },
                1024: {
                    slidesPerView: 2.8,
                },
            },
        });

        var swiper = new Swiper('.problemsSwiper', {
            slidesPerView: '7',
            spaceBetween: 12,
            loop: true,

        });


        var swiper = new Swiper('.expertSwiper', {
            slidesPerView: 4.2,
            spaceBetween: 20,
            freeMode: true,
            breakpoints: {
                576: {
                    slidesPerView: 2.2,
                },
                768: {
                    slidesPerView: 3.2,
                },
                1024: {
                    slidesPerView: 4.2,
                }
            }
        });
    </script>




</body>

</html><?php /**PATH /home/quickmed/public_html/website/resources/views/for_patients.blade.php ENDPATH**/ ?>