<!DOCTYPE html>
<html lang="<?php echo e(app()->getLocale()); ?>">

<head>
    <meta charset="UTF-8">
    <title>Language Switch</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
</head>

<body>
    <div class="dropdown">
        <button class="btn btn-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown">
            🌐 <?php echo e(strtoupper(app()->getLocale())); ?>

        </button>
        <ul class="dropdown-menu">
            <li><a class="dropdown-item" href="<?php echo e(url('lang/en')); ?>">English</a></li>
            <li><a class="dropdown-item" href="<?php echo e(url('lang/hi')); ?>">हिन्दी</a></li>
        </ul>
    </div>


    <p>Current locale: <?php echo e(App::getLocale()); ?></p>
    <h4><img src="images/header/img2.png"> <?php echo e(__('messages.health_priority')); ?></h4>
    <h1>
        <?php echo e(__('messages.consult_title')); ?><br>
        <?php echo e(__('messages.anywhere')); ?>

        <span class="highlight"><?php echo e(__('messages.in_switzerland')); ?></span>
    </h1>
    <p><?php echo e(__('messages.connect_text')); ?></p>
    <p class="text"><?php echo e(__('messages.download_app')); ?></p>



    <div class="app-buttons">
        <a href="javascript:void(0);">
            <img src="https://developer.apple.com/assets/elements/badges/download-on-the-app-store.svg" alt="App Store">
        </a>
        <a href="javascript:void(0);">
            <img src="https://upload.wikimedia.org/wikipedia/commons/7/78/Google_Play_Store_badge_EN.svg" alt="Google Play" class="google">
        </a>
    </div>
    </div>
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>

</html><?php /**PATH C:\xampp\htdocs\quickmed\resources\views/demo.blade.php ENDPATH**/ ?>